/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.injectors.bedrock;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.preferences.bindings.Action;
import dev.letsgoaway.geyserextras.core.preferences.bindings.Remappable;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.packet.InteractPacket;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.bedrock.entity.player.BedrockInteractTranslator;

@Translator(packet=InteractPacket.class)
public class BedrockInteractInjector
extends BedrockInteractTranslator {
    public void translate(GeyserSession session, InteractPacket packet) {
        ExtrasPlayer player = ExtrasPlayer.get((GeyserConnection)session);
        if (!packet.getAction().equals((Object)InteractPacket.Action.OPEN_INVENTORY)) {
            if (GeyserExtras.GE.getConfig().isEnableCustomCooldown()) {
                if (packet.getAction().equals((Object)InteractPacket.Action.DAMAGE)) {
                    player.getCooldownHandler().setDigTicks(-1);
                    player.getCooldownHandler().setLastSwingTime(System.currentTimeMillis());
                    player.hungerSprintCancel();
                } else if (packet.getAction().equals((Object)InteractPacket.Action.MOUSEOVER)) {
                    player.getCooldownHandler().setLastMouseoverID(packet.getRuntimeEntityId());
                }
            }
            super.translate(session, packet);
        } else {
            Remappable bind;
            if (player.getPreferences().isEnableDoubleClickShortcut() && GeyserExtras.GE.getConfig().isEnableGeyserExtrasMenu() && (!player.getSession().isSneaking() || player.getPreferences().isDefault(Remappable.SNEAK_INVENTORY))) {
                if ((float)player.getPreferences().getDoubleClickMS() > (float)System.currentTimeMillis() - player.getLastInventoryClickTime()) {
                    if (player.getDoubleClickShortcutFuture() != null && !player.getDoubleClickShortcutFuture().isCancelled() && !player.getDoubleClickShortcutFuture().isDone()) {
                        player.getDoubleClickShortcutFuture().cancel(false);
                        Action.OPEN_GE_MENU.run(player);
                    } else {
                        player.setLastInventoryClickTime(System.currentTimeMillis());
                        player.setDoubleClickShortcutFuture(session.scheduleInEventLoop(() -> player.getPreferences().runAction(Remappable.OPEN_INVENTORY), (long)(player.getPreferences().getDoubleClickMS() + 20), TimeUnit.MILLISECONDS));
                    }
                    return;
                }
                player.setLastInventoryClickTime(System.currentTimeMillis());
                player.setDoubleClickShortcutFuture(session.scheduleInEventLoop(() -> player.getPreferences().runAction(Remappable.OPEN_INVENTORY), (long)(player.getPreferences().getDoubleClickMS() + 20), TimeUnit.MILLISECONDS));
                return;
            }
            Remappable remappable = bind = player.getSession().isSneaking() ? Remappable.SNEAK_INVENTORY : Remappable.OPEN_INVENTORY;
            if (player.getPreferences().isDefault(bind) || player.getPreferences().getAction(bind).equals((Object)Action.OPEN_INVENTORY)) {
                super.translate(session, packet);
                return;
            }
            Object entity = packet.getRuntimeEntityId() == session.getPlayerEntity().getGeyserId() ? session.getPlayerEntity() : session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
            if (entity == null) {
                return;
            }
            player.getPreferences().getAction(bind).run(player);
        }
    }
}

