/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.injectors.bedrock;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import java.util.BitSet;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryTransactionType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryTransactionPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.SkullBlock;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockInventoryTransactionTranslator;

@Translator(packet=InventoryTransactionPacket.class)
public class BedrockInventoryTransactionInjector
extends BedrockInventoryTransactionTranslator {
    public void translate(GeyserSession session, InventoryTransactionPacket packet) {
        ExtrasPlayer player = ExtrasPlayer.get((GeyserConnection)session);
        InventoryTransactionType type = packet.getTransactionType();
        super.translate(session, packet);
        if (type.equals((Object)InventoryTransactionType.ITEM_USE_ON_ENTITY)) {
            Entity entity = session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
            if (entity == null) {
                return;
            }
            if (packet.getActionType() == 1) {
                player.getCooldownHandler().setDigTicks(-1);
                player.getCooldownHandler().setLastSwingTime(System.currentTimeMillis());
                player.hungerSprintCancel();
            }
        }
        if (type.equals((Object)InventoryTransactionType.ITEM_USE) && packet.getActionType() == 2) {
            player.getCooldownHandler().setDigTicks(5);
        }
    }

    private void restoreCorrectBlock(GeyserSession session, Vector3i blockPos, InventoryTransactionPacket packet) {
        SkullCache.Skull skull;
        SkullBlock skullBlock;
        BlockState javaBlockState = session.getGeyser().getWorldManager().blockAt(session, blockPos);
        GeyserBedrockBlock bedrockBlock = session.getBlockMappings().getBedrockBlock(javaBlockState);
        Block block = javaBlockState.block();
        if (block instanceof SkullBlock && (skullBlock = (SkullBlock)block).skullType() == SkullBlock.Type.PLAYER && (skull = (SkullCache.Skull)session.getSkullCache().getSkulls().get(blockPos)) != null && skull.getBlockDefinition() != null) {
            bedrockBlock = skull.getBlockDefinition();
        }
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(blockPos);
        updateBlockPacket.setDefinition((BlockDefinition)bedrockBlock);
        updateBlockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket((BedrockPacket)updateBlockPacket);
        UpdateBlockPacket updateWaterPacket = new UpdateBlockPacket();
        updateWaterPacket.setDataLayer(1);
        updateWaterPacket.setBlockPosition(blockPos);
        updateWaterPacket.setDefinition((BlockDefinition)(((BitSet)BlockRegistries.WATERLOGGED.get()).get(javaBlockState.javaId()) ? session.getBlockMappings().getBedrockWater() : session.getBlockMappings().getBedrockAir()));
        updateWaterPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket((BedrockPacket)updateWaterPacket);
        InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, (Inventory)session.getPlayerInventory(), session.getPlayerInventory().getOffsetForHotbar(packet.getHotbarSlot()));
    }
}

