/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.injectors.bedrock.input;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.preferences.bindings.Remappable;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.data.PlayerBlockActionData;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.session.GeyserSession;

public class BedrockBlockInteractions {
    public static void translate(GeyserSession session, List<PlayerBlockActionData> playerActions) {
        session.getBookEditCache().checkForSend();
        for (PlayerBlockActionData blockActionData : playerActions) {
            BedrockBlockInteractions.handle(session, blockActionData);
        }
    }

    private static void handle(GeyserSession session, PlayerBlockActionData blockActionData) {
        PlayerActionType action = blockActionData.getAction();
        ExtrasPlayer player = ExtrasPlayer.get((GeyserConnection)session);
        switch (action) {
            case DROP_ITEM: {
                if (!session.isSneaking()) break;
                player.getPreferences().runAction(Remappable.SNEAK_DROP);
                session.getPlayerInventoryHolder().updateInventory();
                break;
            }
            case START_BREAK: {
                player.getCooldownHandler().setDigTicks(0);
                player.getCooldownHandler().setLastSwingTime(System.currentTimeMillis());
                break;
            }
            case CONTINUE_BREAK: {
                ++player.getCooldownHandler().digTicks;
                if (player.getCooldownHandler().getDigTicks() <= 4) break;
                player.getCooldownHandler().setDigTicks(0);
                player.getCooldownHandler().setLastSwingTime(System.currentTimeMillis());
                break;
            }
            case STOP_BREAK: {
                player.getCooldownHandler().setDigTicks(0);
                break;
            }
            case ABORT_BREAK: {
                if (player.getCooldownHandler().getDigTicks() == 5) break;
                player.getCooldownHandler().setDigTicks(-1);
            }
        }
    }
}

