/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.preferences.bindings;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.menus.MainMenu;
import dev.letsgoaway.geyserextras.core.parity.java.menus.tablist.PlayerListMenu;
import org.geysermc.geyser.entity.type.ChestBoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.ClientCommand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundClientCommandPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;

public enum Action {
    DEFAULT,
    DISABLED,
    SWAP_OFFHAND,
    RECONNECT,
    TOGGLE_TOOLTIPS,
    OPEN_GE_MENU,
    OPEN_ADVANCEMENTS,
    OPEN_STATISTICS,
    PLAYER_LIST,
    PLATFORM_LIST,
    OPEN_INVENTORY,
    NEXT_LOCKED_PERSPECTIVE;


    public void run(ExtrasPlayer player) {
        GeyserSession session = player.getSession();
        switch (this) {
            case SWAP_OFFHAND: {
                session.requestOffhandSwap();
                break;
            }
            case RECONNECT: {
                player.reconnect();
                break;
            }
            case TOGGLE_TOOLTIPS: {
                session.setAdvancedTooltips(!session.isAdvancedTooltips());
                String onOrOff = session.isAdvancedTooltips() ? "on" : "off";
                session.sendMessage("\u00a7l\u00a7e" + player.translate("debug.prefix") + " \u00a7r" + player.translate("debug.advanced_tooltips." + onOrOff));
                session.getPlayerInventoryHolder().updateInventory();
                break;
            }
            case OPEN_GE_MENU: {
                player.sendForm(new MainMenu());
                break;
            }
            case OPEN_ADVANCEMENTS: {
                session.getAdvancementsCache().buildAndShowMenuForm();
                break;
            }
            case OPEN_STATISTICS: {
                session.setWaitingForStatistics(true);
                ServerboundClientCommandPacket packet = new ServerboundClientCommandPacket(ClientCommand.STATS);
                session.sendDownstreamGamePacket((Packet)packet);
                break;
            }
            case PLAYER_LIST: {
                if (!GeyserExtras.GE.getConfig().isEnableGeyserExtrasMenu()) break;
                player.sendForm(new PlayerListMenu());
                break;
            }
            case PLATFORM_LIST: {
                break;
            }
            case OPEN_INVENTORY: {
                if (session.getInventoryHolder() != null) break;
                Entity ridingEntity = session.getPlayerEntity().getVehicle();
                if (ridingEntity instanceof AbstractHorseEntity || ridingEntity instanceof ChestBoatEntity) {
                    ServerboundPlayerCommandPacket openVehicleWindowPacket = new ServerboundPlayerCommandPacket(session.getPlayerEntity().getEntityId(), PlayerState.OPEN_VEHICLE_INVENTORY);
                    session.sendDownstreamGamePacket((Packet)openVehicleWindowPacket);
                    break;
                }
                InventoryUtils.openInventory((InventoryHolder)session.getPlayerInventoryHolder());
                break;
            }
            case NEXT_LOCKED_PERSPECTIVE: {
                player.getPreferences().setLockedPerspective(player.getPreferences().getLockedPerspective().getNext());
                break;
            }
        }
    }

    public String translate(ExtrasPlayer player) {
        switch (this) {
            case DEFAULT: {
                return "%gui.default";
            }
            case DISABLED: {
                return "%options.dev_nethernet_logging_verbosity.disabled";
            }
            case SWAP_OFFHAND: {
                return player.translate("key.swapOffhand");
            }
            case RECONNECT: {
                return player.translateOtherwiseGE("ge.reconnect", "%profileScreen.reload");
            }
            case TOGGLE_TOOLTIPS: {
                GeyserSession session = player.getSession();
                String onOrOff = session.isAdvancedTooltips() ? "on" : "off";
                return player.translate("debug.advanced_tooltips." + onOrOff);
            }
            case OPEN_ADVANCEMENTS: {
                return player.translate("gui.advancements");
            }
            case OPEN_STATISTICS: {
                return "%gui.stats";
            }
            case PLAYER_LIST: {
                return "%key.playerlist";
            }
            case OPEN_GE_MENU: 
            case PLATFORM_LIST: 
            case NEXT_LOCKED_PERSPECTIVE: {
                return player.translateGE("ge.settings.bindings.actions." + this.name().toLowerCase());
            }
            case OPEN_INVENTORY: {
                return "%key.script_open_inventory";
            }
        }
        return this.name();
    }
}

