/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.utils;

import org.cloudburstmc.math.imaginary.Quaternionf;
import org.cloudburstmc.math.vector.Vector3f;

public class MathUtils {
    public static double restrain(double x, double max) {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.min(x, max);
    }

    public static int ceil(float floatNumber) {
        int truncated = (int)floatNumber;
        return floatNumber > (float)truncated ? truncated + 1 : truncated;
    }

    public static double constrain(double num, double min, double max) {
        if (num > max) {
            num = max;
        }
        if (num < min) {
            num = min;
        }
        return num;
    }

    public static int constrain(int num, int min, int max) {
        if (num > max) {
            num = max;
        }
        if (num < min) {
            num = min;
        }
        return num;
    }

    public static float clamp(float value, float low, float high) {
        if (value < low) {
            return low;
        }
        if (value > high) {
            return high;
        }
        return value;
    }

    public static float clampOne(float value) {
        return MathUtils.clamp(value, -1.0f, 1.0f);
    }

    public static Vector3f toEuler(Quaternionf q) {
        float sqw = q.getW() * q.getW();
        float sqx = q.getX() * q.getX();
        float sqy = q.getY() * q.getY();
        float sqz = q.getZ() * q.getZ();
        float unit = sqx + sqy + sqz + sqw;
        float test = q.getX() * q.getY() + q.getZ() * q.getW();
        Vector3f v = (double)test > 0.499 * (double)unit ? Vector3f.from((double)0.0, (double)(2.0 * Math.atan2(q.getX(), q.getW())), (double)1.5707963267948966) : ((double)test < -0.499 * (double)unit ? Vector3f.from((double)0.0, (double)(-2.0 * Math.atan2(q.getX(), q.getW())), (double)-1.5707963267948966) : Vector3f.from((double)Math.atan2(2.0f * q.getX() * q.getW() - 2.0f * q.getY() * q.getZ(), -sqx + sqy - sqz + sqw), (double)Math.atan2(2.0f * q.getY() * q.getW() - 2.0f * q.getX() * q.getZ(), sqx - sqy - sqz + sqw), (double)Math.asin(2.0f * test / unit)));
        return v;
    }
}

