/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import dev.letsgoaway.geyserextras.Server;
import dev.letsgoaway.geyserextras.ServerType;
import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.commands.CommandExecutor;
import dev.letsgoaway.geyserextras.core.parity.bedrock.EmoteUtils;
import dev.letsgoaway.geyserextras.core.preferences.JavaPreferencesData;
import dev.letsgoaway.geyserextras.core.protocol.ProtocolHandler;
import dev.letsgoaway.geyserextras.core.utils.IdUtils;
import dev.letsgoaway.geyserextras.core.utils.IsAvailable;
import dev.letsgoaway.geyserextras.core.utils.TickUtil;
import dev.letsgoaway.geyserextras.velocity.VelocityCommandHandler;
import dev.letsgoaway.geyserextras.velocity.VelocityExtrasPlayer;
import dev.letsgoaway.geyserextras.velocity.VelocityListener;
import dev.letsgoaway.geyserextras.velocity.VelocityTickUtil;
import io.github.retrooper.packetevents.velocity.factory.VelocityPacketEventsBuilder;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.level.JavaDimension;
import org.slf4j.Logger;

@Plugin(authors={"LetsGoAway"}, name="GeyserExtras", version="2.0.0-BETA-9", id="geyserextras", dependencies={@Dependency(id="geyser")})
public class GeyserExtrasVelocity
implements Server {
    public static GeyserExtras CORE;
    public static GeyserExtrasVelocity VELOCITY;
    public static ProxyServer server;
    private final Logger logger;
    private final PluginContainer container;
    private final VelocityTickUtil velocityTickUtil;
    private final Path dataDirectory;

    @Inject
    public GeyserExtrasVelocity(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        ServerType.type = ServerType.VELOCITY;
        VELOCITY = this;
        GeyserExtrasVelocity.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.container = server.getPluginManager().ensurePluginContainer((Object)this);
        this.velocityTickUtil = new VelocityTickUtil();
        if (IsAvailable.packetevents()) {
            ProtocolHandler.load(VelocityPacketEventsBuilder.build((ProxyServer)server, (PluginContainer)this.container, (Logger)logger, (Path)this.dataDirectory));
        }
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        CORE = new GeyserExtras(this);
        if (IsAvailable.packetevents()) {
            ProtocolHandler.init();
        }
    }

    @Subscribe
    public void onProxyReload(ProxyReloadEvent ev) {
        CORE.autoReconnectAll();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent ev) {
        CORE.autoReconnectAll();
        if (IsAvailable.packetevents()) {
            ProtocolHandler.terminate();
        }
    }

    @Override
    public void onGeyserExtrasInitialize() {
        CommandManager commandManager = server.getCommandManager();
        for (String label : CommandExecutor.ids.keySet()) {
            commandManager.register(commandManager.metaBuilder(label).build(), (Command)new VelocityCommandHandler());
        }
        server.getEventManager().register((Object)this, (Object)new VelocityListener());
    }

    @Override
    public TickUtil getTickUtil() {
        return this.velocityTickUtil;
    }

    @Override
    public ExtrasPlayer createPlayer(GeyserConnection connection) {
        return new VelocityExtrasPlayer(connection);
    }

    @Override
    public void log(String string) {
        this.logger.info(string);
    }

    @Override
    public void warn(String string) {
        this.logger.warn(string);
    }

    @Override
    public Path getPluginFolder() {
        return this.dataDirectory;
    }

    @Override
    public void sendEmoteChat(ExtrasPlayer player, String emoteChat) {
        VelocityExtrasPlayer velocityPlayer = (VelocityExtrasPlayer)player;
        Vector3f playerPos = velocityPlayer.getSession().getPlayerEntity().getPosition();
        JavaDimension dimension = velocityPlayer.getSession().getDimensionType();
        for (Player playerNear : this.getServerPlayers(velocityPlayer.player)) {
            JavaDimension playerNearDimension;
            PlayerEntity entity;
            JavaPreferencesData userPrefs;
            UUID javaUUID = playerNear.getUniqueId();
            boolean isBedrock = IdUtils.isBedrockPlayer(javaUUID);
            if (isBedrock || (userPrefs = GeyserExtras.GE.getJavaPreferencesData(javaUUID)) != null && userPrefs.muteEmoteChat || (entity = velocityPlayer.getSession().getEntityCache().getPlayerEntity(javaUUID)) == null || (playerNearDimension = player.getPlayerDimensionsMap().get(entity.getEntityId())) != dimension || !(EmoteUtils.EMOTE_DISTANCE >= playerPos.distance(entity.getPosition()))) continue;
            playerNear.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(emoteChat));
        }
    }

    private Collection<Player> getServerPlayers(Player player) {
        Optional connectionOptional = player.getCurrentServer();
        if (connectionOptional.isPresent()) {
            ServerConnection server = (ServerConnection)connectionOptional.get();
            return server.getServer().getPlayersConnected();
        }
        return Collections.emptySet();
    }

    @Override
    public void sendRawMessage(UUID javaPlayer, String message) {
        Optional optPlayer = server.getPlayer(javaPlayer);
        optPlayer.ifPresent(player -> player.sendPlainMessage(message));
    }

    @Override
    public void sendMessage(UUID javaPlayer, String message) {
        Optional optPlayer = server.getPlayer(javaPlayer);
        optPlayer.ifPresent(player -> player.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(message)));
    }
}

