/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.scheduler.Scheduler;
import com.velocitypowered.api.scheduler.TaskStatus;
import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.utils.TickMath;
import dev.letsgoaway.geyserextras.velocity.GeyserExtrasVelocity;
import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.api.connection.GeyserConnection;

public class VelocityExtrasPlayer
extends ExtrasPlayer {
    public Player player;
    Scheduler.TaskBuilder builder;
    ScheduledTask task;
    Scheduler scheduler = GeyserExtrasVelocity.server.getScheduler();

    public VelocityExtrasPlayer(GeyserConnection connection) {
        super(connection);
    }

    @Override
    public void startGame() {
        super.startGame();
        this.setTickingState(20.0f);
        GeyserExtrasVelocity.server.getPlayer(this.getJavaUUID()).ifPresent(value -> {
            this.player = value;
        });
    }

    @Override
    public void setTickingState(float tickrate) {
        super.setTickingState(tickrate);
        if (this.builder == null) {
            this.builder = this.scheduler.buildTask((Object)GeyserExtrasVelocity.VELOCITY, this::tick);
        }
        if (this.task != null && this.task.status().equals((Object)TaskStatus.SCHEDULED)) {
            this.task.cancel();
            this.task = null;
        }
        this.builder.clearRepeat();
        this.builder.repeat(TickMath.toNanos(tickrate), TimeUnit.NANOSECONDS);
        this.task = this.builder.schedule();
    }
}

