/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.bungee;

import dev.letsgoaway.geyserextras.Server;
import dev.letsgoaway.geyserextras.ServerType;
import dev.letsgoaway.geyserextras.bungee.BungeeCommandHandler;
import dev.letsgoaway.geyserextras.bungee.BungeeExtrasPlayer;
import dev.letsgoaway.geyserextras.bungee.BungeeListener;
import dev.letsgoaway.geyserextras.bungee.BungeeTickUtil;
import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.commands.CommandExecutor;
import dev.letsgoaway.geyserextras.core.parity.bedrock.EmoteUtils;
import dev.letsgoaway.geyserextras.core.preferences.JavaPreferencesData;
import dev.letsgoaway.geyserextras.core.protocol.ProtocolHandler;
import dev.letsgoaway.geyserextras.core.utils.IdUtils;
import dev.letsgoaway.geyserextras.core.utils.IsAvailable;
import dev.letsgoaway.geyserextras.core.utils.TickUtil;
import io.github.retrooper.packetevents.bungee.factory.BungeePacketEventsBuilder;
import java.nio.file.Path;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.level.JavaDimension;

public class GeyserExtrasBungee
extends Plugin
implements Server {
    public static GeyserExtras CORE;
    public static Plugin BUNGEE;
    private static BungeeTickUtil bungeeTickUtil;

    public GeyserExtrasBungee() {
        ServerType.type = ServerType.BUNGEECORD;
        BUNGEE = this;
        bungeeTickUtil = new BungeeTickUtil();
    }

    public void onLoad() {
        if (IsAvailable.packetevents()) {
            ProtocolHandler.load(BungeePacketEventsBuilder.build((Plugin)this));
        }
    }

    public void onEnable() {
        CORE = new GeyserExtras(this);
        if (IsAvailable.packetevents()) {
            ProtocolHandler.init();
        }
    }

    public void onDisable() {
        CORE.autoReconnectAll();
        if (IsAvailable.packetevents()) {
            ProtocolHandler.terminate();
        }
    }

    @Override
    public void onGeyserExtrasInitialize() {
        for (String label : CommandExecutor.ids.keySet()) {
            ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new BungeeCommandHandler(label));
        }
        ProxyServer.getInstance().getPluginManager().registerListener((Plugin)this, (Listener)new BungeeListener());
    }

    @Override
    public TickUtil getTickUtil() {
        return bungeeTickUtil;
    }

    @Override
    public ExtrasPlayer createPlayer(GeyserConnection connection) {
        return new BungeeExtrasPlayer(connection);
    }

    @Override
    public void log(String string) {
        this.getLogger().info(string);
    }

    @Override
    public void warn(String string) {
        this.getLogger().warning(string);
    }

    @Override
    public Path getPluginFolder() {
        return this.getDataFolder().toPath();
    }

    @Override
    public void sendEmoteChat(ExtrasPlayer player, String emoteChat) {
        BungeeExtrasPlayer bungeePlayer = (BungeeExtrasPlayer)player;
        Vector3f playerPos = bungeePlayer.getSession().getPlayerEntity().getPosition();
        TextComponent component = new TextComponent();
        component.setText(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)emoteChat));
        JavaDimension dimension = bungeePlayer.getSession().getDimensionType();
        for (ProxiedPlayer playerNear : bungeePlayer.player.getServer().getInfo().getPlayers()) {
            JavaDimension playerNearDimension;
            PlayerEntity entity;
            JavaPreferencesData userPrefs;
            UUID javaUUID = playerNear.getUniqueId();
            boolean isBedrock = IdUtils.isBedrockPlayer(javaUUID);
            if (isBedrock || (userPrefs = GeyserExtras.GE.getJavaPreferencesData(javaUUID)) != null && userPrefs.muteEmoteChat || (entity = bungeePlayer.getSession().getEntityCache().getPlayerEntity(javaUUID)) == null || (playerNearDimension = player.getPlayerDimensionsMap().get(entity.getEntityId())) != dimension || !(EmoteUtils.EMOTE_DISTANCE >= playerPos.distance(entity.getPosition()))) continue;
            playerNear.sendMessage(ChatMessageType.SYSTEM, (BaseComponent)component);
        }
    }

    @Override
    public void sendRawMessage(UUID javaPlayer, String message) {
        ProxyServer.getInstance().getPlayer(javaPlayer).sendMessage(message);
    }

    @Override
    public void sendMessage(UUID javaPlayer, String message) {
        TextComponent component = new TextComponent();
        component.setText(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)message));
        ProxyServer.getInstance().getPlayer(javaPlayer).sendMessage(ChatMessageType.SYSTEM, (BaseComponent)component);
    }
}

