/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.form;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.form.FormElement;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.util.FormImage;

public class BedrockForm {
    private final CustomForm.Builder customForm = CustomForm.builder();
    private final List<FormElement> elements = new ArrayList<FormElement>();
    private String title = "";

    public void add(FormElement elem) {
        this.elements.add(elem);
    }

    public CustomForm.Builder create(ExtrasPlayer player) {
        this.customForm.icon(FormImage.Type.URL, "https://cdn.modrinth.com/data/kOfJBurB/2592d098bd31c083365e1c8d831446220995f1d7.png");
        this.customForm.title(this.title);
        for (FormElement elem : this.elements) {
            this.customForm.component(elem.getComponent());
        }
        this.customForm.validResultHandler(response -> {
            int i = 0;
            response.includeLabels(true);
            for (FormElement element : this.elements) {
                switch (element.getType()) {
                    case DROPDOWN: {
                        element.resultRecieved(response.asDropdown(i));
                        break;
                    }
                    case INPUT: {
                        element.resultRecieved(response.asInput(i));
                        break;
                    }
                    case LABEL: {
                        element.resultRecieved(new Object[]{null});
                        break;
                    }
                    case SLIDER: {
                        element.resultRecieved(Float.valueOf(response.asSlider(i)));
                        break;
                    }
                    case STEPSLIDER: {
                        element.resultRecieved(response.asStepSlider(i));
                        break;
                    }
                    case TOGGLE: {
                        element.resultRecieved(response.asToggle(i));
                        break;
                    }
                }
                ++i;
            }
            this.onSubmit(player);
        });
        this.customForm.closedResultHandler(() -> this.onClose(player));
        this.customForm.invalidResultHandler(() -> GeyserExtras.SERVER.warn("ERROR: FORM RESPONSE BY " + player.getSession().getClientData().getUsername() + " WAS INVALID!"));
        return this.customForm;
    }

    public void onSubmit(ExtrasPlayer player) {
    }

    public void onClose(ExtrasPlayer player) {
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }
}

