/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.injectors.java;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.java.entity.JavaEntityEventTranslator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundEntityEventPacket;

public class JavaEntityEventInjector
extends JavaEntityEventTranslator {
    public void translate(GeyserSession session, ClientboundEntityEventPacket packet) {
        super.translate(session, packet);
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        switch (packet.getEvent()) {
            case PLAYER_SWAP_SAME_ITEM: {
                if (packet.getEntityId() != session.getPlayerEntity().getEntityId()) break;
                ExtrasPlayer player = ExtrasPlayer.get((GeyserConnection)session);
                player.getCooldownHandler().setLastSwingTime(System.currentTimeMillis());
                player.getCooldownHandler().setDigTicks(-1);
                break;
            }
            case LIVING_SHIELD_BLOCK: {
                if (packet.getEntityId() != session.getPlayerEntity().getEntityId()) break;
                PlaySoundPacket playSoundPacket = new PlaySoundPacket();
                playSoundPacket.setSound("item.shield.block");
                playSoundPacket.setPosition(entity.getPosition());
                playSoundPacket.setVolume(0.8f);
                playSoundPacket.setPitch(1.0f);
                session.sendUpstreamPacket((BedrockPacket)playSoundPacket);
            }
        }
    }
}

