/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.parity.java.menus.packs;

import dev.letsgoaway.geyserextras.core.GeyserExtras;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;

public class PackLoader {
    public static Path PACKS_PATH;
    public static LinkedHashMap<UUID, ResourcePack> PACKS;

    public static void initialize() {
        PACKS_PATH = GeyserExtras.SERVER.getPluginFolder().resolve("optionalpacks/");
        try {
            Files.createDirectories(PACKS_PATH, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File packFolder = PACKS_PATH.toFile();
        File[] packs = packFolder.listFiles();
        if (packFolder.exists() && packs != null) {
            for (File pack : packs) {
                String ext = PackLoader.getFileExtension(pack);
                if (!ext.equals(".mcpack")) continue;
                ResourcePack mcpack = ResourcePack.create((PackCodec)PackCodec.path((Path)pack.toPath()));
                GeyserExtras.SERVER.log(mcpack.manifest().header().name() + " loaded!");
                PACKS.put(mcpack.manifest().header().uuid(), mcpack);
            }
        }
    }

    private static String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    static {
        PACKS = new LinkedHashMap();
    }
}

