/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.preferences;

import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.cache.Cache;
import dev.letsgoaway.geyserextras.core.preferences.PreferencesData;
import dev.letsgoaway.relocate.com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public class JavaPreferencesData {
    @JsonIgnore
    public static Path JAVA_PREFRENCES_PATH;
    @JsonIgnore
    public static JavaPreferencesData DEFAULT;
    @JsonIgnore
    public UUID javaUUID;
    @JsonIgnore
    public File saveFile;
    public boolean muteEmoteChat = false;

    public JavaPreferencesData() {
        this.javaUUID = null;
    }

    public JavaPreferencesData(UUID javaUUID) {
        this.javaUUID = javaUUID;
        this.saveFile = JAVA_PREFRENCES_PATH.resolve(javaUUID.toString() + ".json").toFile();
        if (this.saveFile.exists()) {
            try {
                FileInputStream data = new FileInputStream(this.saveFile);
                this.copyFrom(Cache.JSON_MAPPER.convertValue((Object)Cache.JSON_MAPPER.readTree(data.readAllBytes()), JavaPreferencesData.class));
            }
            catch (Exception e) {
                GeyserExtras.SERVER.warn("Could not load data for player " + javaUUID + ", restoring to default for them.\n" + e.getLocalizedMessage());
                this.copyFrom(DEFAULT);
            }
        } else {
            this.copyFrom(DEFAULT);
        }
    }

    public static void init() {
        JAVA_PREFRENCES_PATH = PreferencesData.PREFERENCES_PATH.resolve("java/");
        try {
            Files.createDirectories(JAVA_PREFRENCES_PATH, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Path defaultPath = JAVA_PREFRENCES_PATH.resolve("default.json");
        DEFAULT = new JavaPreferencesData();
        try {
            if (defaultPath.toFile().exists()) {
                FileInputStream data = new FileInputStream(defaultPath.toFile());
                DEFAULT.copyFrom(Cache.JSON_MAPPER.convertValue((Object)Cache.JSON_MAPPER.readTree(data.readAllBytes()), JavaPreferencesData.class));
            }
            Cache.JSON_MAPPER.writeValue(defaultPath.toFile(), (Object)DEFAULT);
        }
        catch (Exception e) {
            GeyserExtras.SERVER.warn("Could not load custom default Java player settings, new players will recieve factory\ndefault's, no changes have been made to default.json.\n" + e.getLocalizedMessage());
        }
    }

    public static JavaPreferencesData load(UUID javaUUID) {
        return new JavaPreferencesData(javaUUID);
    }

    public void copyFrom(JavaPreferencesData data) {
        this.muteEmoteChat = data.muteEmoteChat;
    }

    public void save() {
        new Thread(() -> {
            try {
                if (!Cache.JSON_MAPPER.writeValueAsString(this).equals(Cache.JSON_MAPPER.writeValueAsString(DEFAULT))) {
                    Cache.JSON_MAPPER.writeValue(this.saveFile, (Object)this);
                } else if (this.saveFile.exists()) {
                    this.saveFile.delete();
                }
            }
            catch (IOException e) {
                GeyserExtras.SERVER.warn("Could not save data for player " + this.javaUUID + "\n" + e.getLocalizedMessage());
            }
        }).start();
    }
}

