/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.preferences;

import java.util.LinkedHashMap;
import org.geysermc.geyser.api.bedrock.camera.CameraPerspective;
import org.geysermc.geyser.session.GeyserSession;

public enum Perspectives {
    OFF,
    FIRST_PERSON,
    THIRD_PERSON_BACK,
    THIRD_PERSON_FRONT;


    public static String translate(Perspectives perspective) {
        switch (perspective) {
            case OFF: {
                return "%options.off";
            }
            case FIRST_PERSON: {
                return "%options.thirdperson.firstperson";
            }
            case THIRD_PERSON_BACK: {
                return "%options.thirdperson.thirdpersonback";
            }
            case THIRD_PERSON_FRONT: {
                return "%options.thirdperson.thirdpersonfront";
            }
        }
        return perspective.name();
    }

    public CameraPerspective getGeyser() {
        switch (this) {
            case OFF: {
                return null;
            }
            case FIRST_PERSON: {
                return CameraPerspective.FIRST_PERSON;
            }
            case THIRD_PERSON_BACK: {
                return CameraPerspective.THIRD_PERSON;
            }
            case THIRD_PERSON_FRONT: {
                return CameraPerspective.THIRD_PERSON_FRONT;
            }
        }
        return CameraPerspective.FIRST_PERSON;
    }

    public Perspectives getNext() {
        switch (this) {
            case FIRST_PERSON: {
                return THIRD_PERSON_BACK;
            }
            case THIRD_PERSON_BACK: {
                return THIRD_PERSON_FRONT;
            }
            case THIRD_PERSON_FRONT: {
                return FIRST_PERSON;
            }
        }
        return THIRD_PERSON_BACK;
    }

    public static LinkedHashMap<String, Perspectives> buildTranslations(GeyserSession session) {
        LinkedHashMap<String, Perspectives> translations = new LinkedHashMap<String, Perspectives>();
        for (Perspectives perspective : Perspectives.values()) {
            translations.put(Perspectives.translate(perspective), perspective);
        }
        return translations;
    }
}

