/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.protocol;

import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.player.User;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.preferences.JavaPreferencesData;
import dev.letsgoaway.geyserextras.core.protocol.ProtocolHandler;
import dev.letsgoaway.geyserextras.core.protocol.handlers.JavaPacketHandler;
import dev.letsgoaway.geyserextras.core.protocol.handlers.workarounds.MannequinCapeWorkaround;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;

public class JavaPlayer {
    ArrayList<JavaPacketHandler> handlers = new ArrayList();
    User user;

    public JavaPlayer(User user) {
        this.user = user;
        this.createHandlers();
    }

    public JavaPreferencesData getPreferences() {
        return GeyserExtras.GE.getJavaPreferencesData(this.user.getUUID());
    }

    private void createHandlers() {
        if (GeyserExtras.GE.getConfig().isEnableBedrockCapesOnJavaWorkaround()) {
            this.handlers.add(new MannequinCapeWorkaround());
        }
    }

    public void onPacketSend(PacketSendEvent event) {
        for (JavaPacketHandler handler : this.handlers) {
            if (event.isCancelled() && !handler.runIfCancelled()) continue;
            handler.onPacketSend(this, event);
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        for (JavaPacketHandler handler : this.handlers) {
            if (event.isCancelled() && !handler.runIfCancelled()) continue;
            handler.onPacketReceive(this, event);
        }
    }

    public static JavaPlayer get(UUID uuid) {
        return ProtocolHandler.getJavaPlayer(uuid);
    }

    public static boolean exists(UUID uuid) {
        return ProtocolHandler.javaPlayerExists(uuid);
    }

    @Generated
    public User getUser() {
        return this.user;
    }
}

