/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.config;

import dev.letsgoaway.geyserextras.ServerType;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.config.GeyserExtrasConfig;
import dev.letsgoaway.geyserextras.core.utils.IsAvailable;
import dev.letsgoaway.relocate.org.spongepowered.configurate.CommentedConfigurationNode;
import dev.letsgoaway.relocate.org.spongepowered.configurate.ConfigurateException;
import dev.letsgoaway.relocate.org.spongepowered.configurate.NodePath;
import dev.letsgoaway.relocate.org.spongepowered.configurate.loader.HeaderMode;
import dev.letsgoaway.relocate.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import dev.letsgoaway.relocate.org.spongepowered.configurate.transformation.TransformAction;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.NodeStyle;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import java.nio.file.Path;

public class ConfigLoader {
    public static final int LATEST_VERSION = 4;
    private static final String HEADER = "GeyserExtras\nIf Geyser is detected, all required config changes will be automatically applied.\nFor more details, go to https://geyserextras.letsgoaway.dev/\n";
    private static final ConfigurationTransformation.Versioned transformer = ConfigurationTransformation.versionedBuilder().addVersion(1, ConfigLoader.zeroToOne()).addVersion(2, ConfigLoader.oneToTwo()).addVersion(3, ConfigLoader.twoToThree()).addVersion(4, ConfigLoader.threeToFour()).build();

    public static void load() {
        Path configPath = GeyserExtras.SERVER.getPluginFolder().resolve("config.yml");
        if (ServerType.isExtension() && !GeyserExtras.SERVER.getPluginFolder().toFile().exists() && !GeyserExtras.SERVER.getPluginFolder().toFile().mkdirs()) {
            GeyserExtras.SERVER.warn("Failed to create data folder");
        }
        boolean existingConfig = configPath.toFile().exists();
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESERVE)).defaultOptions(options -> options.header(HEADER))).build();
        try {
            CommentedConfigurationNode configurationNode = (CommentedConfigurationNode)loader.load();
            int currentVersion = transformer.version(configurationNode);
            if (currentVersion != 4) {
                transformer.apply(configurationNode);
            }
            GeyserExtrasConfig config = configurationNode.get(GeyserExtrasConfig.class);
            CommentedConfigurationNode newNode = CommentedConfigurationNode.root(loader.defaultOptions());
            newNode.set(GeyserExtrasConfig.class, (Object)config);
            if (!existingConfig || currentVersion != 4) {
                loader.save(newNode);
            }
            GeyserExtras.GE.setConfig(config);
        }
        catch (ConfigurateException e) {
            GeyserExtras.SERVER.warn("Failed to load config! Using defaults.\n" + e.getMessage());
            GeyserExtras.GE.setConfig(new GeyserExtrasConfig());
        }
        try {
            if (GeyserExtras.GE.getConfig().isEnableCustomCooldown()) {
                ConfigLoader.updateGeyserConfig();
            }
        }
        catch (ConfigurateException e) {
            GeyserExtras.SERVER.warn("Could not update Geyser config!\n" + e.rawMessage());
        }
        if (IsAvailable.floodgate() && GeyserExtras.GE.getConfig().isEnableGeyserExtrasMenu()) {
            GeyserExtras.SERVER.warn("WARNING: Floodgate is installed, so GeyserExtras Settings will not");
            GeyserExtras.SERVER.warn("show up in the Game Settings menu due to how forms work on GeyserMC.");
            GeyserExtras.SERVER.warn("If you want a temporary work around to this, use Geyser-Standalone,");
            GeyserExtras.SERVER.warn("otherwise a notification toast will show up informing players that");
            GeyserExtras.SERVER.warn("they will have to double tap inventory.");
        }
    }

    private static ConfigurationTransformation zeroToOne() {
        return ConfigurationTransformation.builder().addAction(NodePath.path("proxy-mode"), TransformAction.remove()).addAction(NodePath.path("external-address"), TransformAction.remove()).addAction(NodePath.path("external-port"), TransformAction.remove()).addAction(NodePath.path("mute-emote-chat"), TransformAction.remove()).addAction(NodePath.path("quick-menu-actions"), TransformAction.remove()).addAction(NodePath.path("enable-java-only-block-placement"), TransformAction.remove()).addAction(NodePath.path("enable-block-ghosting-fix"), TransformAction.remove()).addAction(NodePath.path("enable-knockback-attack-sprint-fix"), TransformAction.remove()).build();
    }

    private static ConfigurationTransformation oneToTwo() {
        return ConfigurationTransformation.builder().addAction(NodePath.path("quick-menu-actions"), TransformAction.remove()).addAction(NodePath.path("enable-java-only-block-placement"), TransformAction.remove()).addAction(NodePath.path("enable-block-ghosting-fix"), TransformAction.remove()).addAction(NodePath.path("enable-knockback-attack-sprint-fix"), TransformAction.remove()).build();
    }

    private static ConfigurationTransformation twoToThree() {
        return ConfigurationTransformation.builder().build();
    }

    private static ConfigurationTransformation threeToFour() {
        return ConfigurationTransformation.builder().build();
    }

    public static void updateGeyserConfig() throws ConfigurateException {
        Path configPath = GeyserExtras.GE.geyserApi.configDirectory().resolve("config.yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(configPath.toFile())).build();
        CommentedConfigurationNode geyserConfig = (CommentedConfigurationNode)loader.load();
        ((CommentedConfigurationNode)((CommentedConfigurationNode)geyserConfig.node(new Object[]{"gameplay"})).node(new Object[]{"show-cooldown"})).set("title");
        GeyserExtras.SERVER.log("Enabling GeyserIntegratedPack...");
        ((CommentedConfigurationNode)((CommentedConfigurationNode)geyserConfig.node(new Object[]{"gameplay"})).node(new Object[]{"enable-integrated-pack"})).set(true);
        loader.save(geyserConfig);
    }
}

