/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.parity.java.blockdisplay;

import dev.letsgoaway.geyserextras.core.parity.java.blockdisplay.BlockDisplayBaseEntity;
import dev.letsgoaway.geyserextras.core.utils.MathUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import org.cloudburstmc.math.imaginary.Quaternionf;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AnimateEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public class BlockDisplayEntity
extends BlockDisplayBaseEntity
implements Tickable {
    private static final DecimalFormat format = new DecimalFormat("#.###");
    private static final List<String> rendersAs2D = List.of(Items.CAMPFIRE.javaIdentifier(), Items.IRON_BARS.javaIdentifier(), Items.BELL.javaIdentifier());
    private String animationExpression = "";

    public BlockDisplayEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public static EntityDefinition<BlockDisplayEntity> buildEntityDef() {
        EntityDefinition entityBase = EntityDefinition.builder(Entity::new).addTranslator((MetadataType)MetadataTypes.BYTE, Entity::setFlags).addTranslator((MetadataType)MetadataTypes.INT, Entity::setAir).addTranslator(MetadataTypes.OPTIONAL_COMPONENT, Entity::setDisplayName).addTranslator((MetadataType)MetadataTypes.BOOLEAN, Entity::setDisplayNameVisible).addTranslator((MetadataType)MetadataTypes.BOOLEAN, Entity::setSilent).addTranslator((MetadataType)MetadataTypes.BOOLEAN, Entity::setGravity).addTranslator(MetadataTypes.POSE, (entity, entityMetadata) -> entity.setPose((Pose)entityMetadata.getValue())).addTranslator((MetadataType)MetadataTypes.INT, Entity::setFreezing).build();
        EntityDefinition displayBase = EntityDefinition.inherited(BlockDisplayBaseEntity::new, (EntityDefinition)entityBase).addTranslator(null).addTranslator(null).addTranslator(null).addTranslator(MetadataTypes.VECTOR3, BlockDisplayBaseEntity::setTranslation).addTranslator(MetadataTypes.VECTOR3, BlockDisplayBaseEntity::setScale).addTranslator(MetadataTypes.QUATERNION, BlockDisplayBaseEntity::setLeftRotation).addTranslator(MetadataTypes.QUATERNION, BlockDisplayBaseEntity::setRightRotation).addTranslator(null).addTranslator(null).addTranslator(null).addTranslator(null).addTranslator(null).addTranslator(null).addTranslator(null).addTranslator(null).build();
        return EntityDefinition.inherited(BlockDisplayEntity::new, (EntityDefinition)displayBase).type(EntityType.BLOCK_DISPLAY).identifier("minecraft:fox").addTranslator((MetadataType)MetadataTypes.BLOCK_STATE, BlockDisplayEntity::setBlock).build();
    }

    public void spawnEntity() {
        this.position = this.position.add(this.getTranslationOffsetSub());
        super.spawnEntity();
        this.dirtyMetadata.put(EntityDataTypes.COLLISION_BOX, (Object)Vector3f.ZERO);
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, (Object)Float.valueOf(0.0f));
        this.dirtyMetadata.put(EntityDataTypes.HEIGHT, (Object)Float.valueOf(0.0f));
        this.setFlag(EntityFlag.SILENT, true);
        this.setFlag(EntityFlag.INVISIBLE, true);
        this.setFlag(EntityFlag.NO_AI, true);
        this.setFlag(EntityFlag.HAS_COLLISION, false);
        this.setFlag(EntityFlag.HAS_GRAVITY, false);
        this.setFlag(EntityFlag.PUSH_TOWARDS_CLOSEST_SPACE, false);
        this.updateBedrockMetadata();
    }

    public void drawTick() {
        this.animationExpression = "";
        this.buildScale();
        this.buildTranslation();
        this.buildRotation();
        this.animate("animation.player.attack.positions", this.animationExpression.replace("=-0;", "=0;"), "ge:setvariable");
        this.animate("animation.player.sleeping", "", "controller.animation.fox.move");
        this.animate("animation.creeper.swelling", "v.xbasepos=v.xbasepos??0;v.ybasepos=v.ybasepos??0;v.zbasepos=v.zbasepos??0;v.xpos=v.xpos??0;v.ypos=v.ypos??0;v.zpos=v.zpos??0;v.xrot=v.xrot??0;v.yrot=v.yrot??0;v.zrot=v.zrot??0;v.scale=v.scale??1;v.xzscale=v.xzscale??1;v.yscale=v.yscale??1;v.swelling_scale1=2.1385*math.sqrt(v.xzscale)*math.sqrt(v.scale);v.swelling_scale2=2.1385*math.sqrt(v.yscale)*math.sqrt(v.scale);", "ge:scale");
        this.animate("animation.ender_dragon.neck_head_movement", "v.head_rotation_x=0;v.head_rotation_y=0;v.head_rotation_z=0;v.head_position_x=(v.xbasepos*3741/8000)*math.sqrt(v.xzscale)*math.sqrt(v.scale);v.head_position_y=(10.6925+v.ybasepos*3741/8000)*math.sqrt(v.yscale)*math.sqrt(v.scale);v.head_position_z=(17.108-v.zbasepos*3741/8000)*math.sqrt(v.xzscale)*math.sqrt(v.scale);", "ge:shift_pos");
        this.animate("animation.warden.move", "v.body_x_rot=90+v.xrot;v.body_z_rot=90+v.yrot;", "ge:xrot");
        this.animate("animation.player.attack.rotations", "v.attack_body_rot_y=-v.zrot;", "ge:zrot");
        this.animate("animation.parrot.moving", "v.wing_flap=(16-v.xpos)/0.3;", "ge:xpos");
        this.animate("animation.minecart.move.v1.0", "v.rail_offset.x=0;v.rail_offset.y=1.6485+v.ypos/16;v.rail_offset.z=0;", "ge:ypos");
        this.animate("animation.parrot.dance", "v.dance.x=-v.zpos;v.dance.y=0;", "ge:zpos");
    }

    public void tick() {
    }

    private void animate(String anim, String stopExpression, String controller) {
        AnimateEntityPacket animation = new AnimateEntityPacket();
        animation.setAnimation(anim);
        animation.setNextState("none");
        animation.setBlendOutTime(0.0f);
        animation.setStopExpression(stopExpression);
        animation.setController(controller);
        animation.getRuntimeEntityIds().add(this.geyserId);
        this.session.sendUpstreamPacket((BedrockPacket)animation);
    }

    public void setBlock(IntEntityMetadata entityMetadata) {
        BlockState state = BlockState.of((int)entityMetadata.getPrimitiveValue());
        Block block = state.block();
        Item item = BlockItem.byBlock((Block)block);
        if (item.javaIdentifier().contains("_door") || item.javaIdentifier().contains("_candle")) {
            this.setHand(Items.AIR.newItemStack(1, null));
            this.updateMainHand();
            return;
        }
        if (rendersAs2D.contains(block.javaIdentifier().toString())) {
            this.setHand(Items.AIR.newItemStack(1, null));
            this.updateMainHand();
            return;
        }
        this.setHand(item.newItemStack(1, null));
        this.updateMainHand();
    }

    private String mlVAR(String name, float variable) {
        return "v." + name + "=" + format.format(variable) + ";";
    }

    private String mlVAR(String name, double variable) {
        return "v." + name + "=" + format.format(variable) + ";";
    }

    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.position = position;
        this.moveAbsoluteImmediate(position.add(this.getTranslationOffsetSub()));
    }

    protected void moveAbsoluteImmediate(Vector3f position) {
        this.moveAbsoluteImmediate(position, this.yaw, this.pitch, this.headYaw, this.isOnGround(), false);
    }

    protected void moveAbsoluteImmediate(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        MoveEntityDeltaPacket moveEntityDeltaPacket = new MoveEntityDeltaPacket();
        moveEntityDeltaPacket.setRuntimeEntityId(this.geyserId);
        if (isOnGround) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.ON_GROUND);
        }
        this.setOnGround(isOnGround);
        if (teleported) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.TELEPORTING);
        }
        if (this.position.getX() != position.getX()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
            moveEntityDeltaPacket.setX(position.getX());
        }
        if (this.position.getY() != position.getY()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
            moveEntityDeltaPacket.setY(position.getY());
        }
        if (this.position.getZ() != position.getZ()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
            moveEntityDeltaPacket.setZ(position.getZ());
        }
        this.setPosition(position);
        if (this.getYaw() != yaw) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
            moveEntityDeltaPacket.setYaw(yaw);
            this.setYaw(yaw);
        }
        if (this.getPitch() != pitch) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
            moveEntityDeltaPacket.setPitch(pitch);
            this.setPitch(pitch);
        }
        if (this.getHeadYaw() != headYaw) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW);
            moveEntityDeltaPacket.setHeadYaw(headYaw);
            this.setHeadYaw(headYaw);
        }
        if (!moveEntityDeltaPacket.getFlags().isEmpty()) {
            this.session.sendUpstreamPacket((BedrockPacket)moveEntityDeltaPacket);
        }
    }

    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
    }

    private void buildTranslation() {
        this.animationExpression = this.animationExpression + this.mlVAR("xpos", this.getTranslationOffset().getX() * 16.0f) + this.mlVAR("ypos", this.getTranslationOffset().getY() * 16.0f) + this.mlVAR("zpos", this.getTranslationOffset().getZ() * 16.0f);
        this.animationExpression = this.animationExpression + this.mlVAR("xbasepos", 8.0) + this.mlVAR("ybasepos", 8.0) + this.mlVAR("zbasepos", 8.0);
    }

    private Vector3f getTranslationOffset() {
        return this.getTranslation().add(0.0f, -2.0f, 0.0f);
    }

    private Vector3f getTranslationOffsetSub() {
        return this.getTranslation().sub(0.0, -1.5, 0.0);
    }

    public void buildScale() {
        float xzscale = Math.max(this.getScale().getX(), this.getScale().getZ());
        this.animationExpression = this.animationExpression + this.mlVAR("xzscale", xzscale) + this.mlVAR("yscale", this.getScale().getY());
    }

    public void buildRotation() {
        Quaternionf q = this.getLeftRotation();
        q = Quaternionf.from((float)MathUtils.clampOne(q.getX()), (float)MathUtils.clampOne(q.getY()), (float)MathUtils.clampOne(q.getZ()), (float)MathUtils.clampOne(q.getW()));
        Vector3f euler = MathUtils.toEuler(q);
        this.animationExpression = this.animationExpression + this.mlVAR("xrot", Math.toDegrees(euler.getX())) + this.mlVAR("yrot", Math.toDegrees(-euler.getY())) + this.mlVAR("zrot", Math.toDegrees(-euler.getZ()));
    }
}

