/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.preferences;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.cache.Cache;
import dev.letsgoaway.geyserextras.core.menus.Menus;
import dev.letsgoaway.geyserextras.core.preferences.JavaPreferencesData;
import dev.letsgoaway.geyserextras.core.preferences.Perspectives;
import dev.letsgoaway.geyserextras.core.preferences.bindings.Action;
import dev.letsgoaway.geyserextras.core.preferences.bindings.Remappable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.CooldownUtils;

public class PreferencesData {
    public static Path PREFERENCES_PATH;
    private static PreferencesData DEFAULT;
    private final transient ExtrasPlayer player;
    private final transient GeyserSession session;
    public CooldownUtils.CooldownType cooldownType = CooldownUtils.CooldownType.TITLE;
    public boolean showCoordinates;
    public boolean advancedTooltips = false;
    public boolean customSkullSkins;
    public HashMap<Remappable, Action> remappableActionMap;
    private boolean adjustCooldownWithPing = true;
    private float indicatorUpdateRate = 60.0f;
    private Menus settingsMenuForm = Menus.GE_SETTINGS;
    private boolean enableDoubleClickShortcut = true;
    private int doubleClickMS = 200;
    private boolean promptOnLinks = true;
    private Perspectives lockedPerspective = Perspectives.OFF;
    private List<UUID> selectedPacks = new ArrayList<UUID>();
    private HashMap<UUID, String> selectedSubpacks = new HashMap();
    private boolean sendSystemToasts = true;
    private boolean showFPS = false;

    public PreferencesData(ExtrasPlayer player) {
        this.player = player;
        this.session = player.getSession();
        this.remappableActionMap = new HashMap();
        this.showCoordinates = GeyserImpl.getInstance().config().gameplay().showCoordinates();
        int visibleCustomSkulls = GeyserImpl.getInstance().config().gameplay().maxVisibleCustomSkulls();
        this.customSkullSkins = visibleCustomSkulls > 0 || visibleCustomSkulls == -1;
    }

    public PreferencesData() {
        this.player = null;
        this.session = null;
        this.remappableActionMap = new HashMap();
        this.showCoordinates = GeyserImpl.getInstance().config().gameplay().showCoordinates();
        int visibleCustomSkulls = GeyserImpl.getInstance().config().gameplay().maxVisibleCustomSkulls();
        this.customSkullSkins = visibleCustomSkulls > 0 || visibleCustomSkulls == -1;
    }

    public static void init() {
        PREFERENCES_PATH = GeyserExtras.SERVER.getPluginFolder().resolve("preferences/");
        try {
            Files.createDirectories(PREFERENCES_PATH, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JavaPreferencesData.init();
        Path defaultPath = PREFERENCES_PATH.resolve("default.json");
        DEFAULT = new PreferencesData();
        if (defaultPath.toFile().exists()) {
            try (FileReader reader = new FileReader(defaultPath.toFile());){
                DEFAULT.copyFrom((PreferencesData)Cache.GSON.fromJson((Reader)reader, PreferencesData.class));
                PreferencesData.writeDefaults();
            }
            catch (Exception e) {
                GeyserExtras.SERVER.warn("Could not load custom default settings, new players will recieve factory\ndefault's, no changes have been made to default.json.\n" + e.getLocalizedMessage());
            }
        } else {
            PreferencesData.writeDefaults();
        }
    }

    private static void writeDefaults() {
        Path defaultPath = PREFERENCES_PATH.resolve("default.json");
        try (FileWriter write = new FileWriter(defaultPath.toFile());){
            Cache.GSON.toJson((Object)DEFAULT, (Appendable)write);
        }
        catch (IOException e) {
            GeyserExtras.SERVER.warn("Could not create default preferences file.\n" + e.getLocalizedMessage());
        }
    }

    public void runAction(Remappable binding) {
        if (!this.isDefault(binding)) {
            if (this.remappableActionMap.containsKey((Object)binding)) {
                this.remappableActionMap.get((Object)binding).run(this.player);
            }
        } else {
            switch (binding) {
                case OPEN_INVENTORY: {
                    Action.OPEN_INVENTORY.run(this.player);
                    break;
                }
            }
        }
    }

    public Action getAction(Remappable binding) {
        Action action = this.remappableActionMap.get((Object)binding);
        return action == null ? Action.DEFAULT : action;
    }

    public void update() {
        if (this.session != null) {
            this.cooldownType = this.session.getPreferencesCache().getCooldownPreference();
            this.showCoordinates = this.session.getPreferencesCache().isPrefersShowCoordinates();
            this.advancedTooltips = this.session.isAdvancedTooltips();
            this.customSkullSkins = this.session.getPreferencesCache().showCustomSkulls();
        }
    }

    public void save() {
        this.update();
        if (GeyserExtras.GE.getConfig().isEnableGeyserExtrasMenu()) {
            new Thread(() -> {
                try (FileWriter writer = new FileWriter(this.player.getUserPrefs());){
                    if (!Cache.GSON.toJson((Object)this).equals(Cache.GSON.toJson((Object)DEFAULT))) {
                        Cache.GSON.toJson((Object)this, (Appendable)writer);
                    } else if (this.player.getUserPrefs().exists()) {
                        this.player.getUserPrefs().delete();
                    }
                }
                catch (IOException e) {
                    GeyserExtras.SERVER.warn("Could not save data for player " + this.player.getBedrockXUID() + "\n" + e.getLocalizedMessage());
                }
            }).start();
        }
    }

    public void load() {
        if (this.player.getUserPrefs().exists() && GeyserExtras.GE.getConfig().isEnableGeyserExtrasMenu()) {
            try (FileReader reader = new FileReader(this.player.getUserPrefs());){
                this.copyFrom((PreferencesData)Cache.GSON.fromJson((Reader)reader, PreferencesData.class));
            }
            catch (Exception e) {
                GeyserExtras.SERVER.warn("Could not load data for player " + this.player.getBedrockXUID() + ", restoring to default for them.\n" + e.getLocalizedMessage());
                this.copyFrom(DEFAULT);
            }
        } else {
            GeyserExtras.SERVER.debugWarn("No preferences file found for player " + this.player.getBedrockXUID() + ", using default settings.");
            this.copyFrom(DEFAULT);
        }
        this.onLoad();
    }

    public void onLoad() {
        if (this.session != null) {
            this.session.getPreferencesCache().setCooldownPreference(this.cooldownType);
            this.session.getPreferencesCache().setPrefersShowCoordinates(this.showCoordinates);
            this.session.setAdvancedTooltips(this.advancedTooltips);
            if (this.player.isLoggedIn()) {
                this.session.getPlayerInventoryHolder().updateInventory();
            }
            this.session.getPreferencesCache().setPrefersCustomSkulls(this.customSkullSkins);
        }
    }

    public void copyFrom(PreferencesData data) {
        this.cooldownType = data.cooldownType;
        this.adjustCooldownWithPing = data.adjustCooldownWithPing;
        this.showCoordinates = data.showCoordinates;
        this.advancedTooltips = data.advancedTooltips;
        this.customSkullSkins = data.customSkullSkins;
        this.remappableActionMap = data.remappableActionMap;
        this.indicatorUpdateRate = data.indicatorUpdateRate;
        this.settingsMenuForm = data.settingsMenuForm;
        this.enableDoubleClickShortcut = data.enableDoubleClickShortcut;
        this.doubleClickMS = data.doubleClickMS;
        this.lockedPerspective = data.lockedPerspective;
        this.selectedPacks = data.selectedPacks;
        this.selectedSubpacks = data.selectedSubpacks;
        this.sendSystemToasts = data.sendSystemToasts;
        this.showFPS = data.showFPS;
    }

    public Action setAction(Remappable binding, Action action) {
        return this.remappableActionMap.put(binding, action);
    }

    public boolean isDefault(Remappable binding) {
        return this.remappableActionMap.get((Object)binding) == null || this.remappableActionMap.get((Object)binding) == Action.DEFAULT;
    }

    public void setLockedPerspective(Perspectives perspective) {
        this.lockedPerspective = perspective;
        if (this.session != null) {
            if (perspective.equals((Object)Perspectives.OFF)) {
                this.session.camera().clearCameraInstructions();
                return;
            }
            assert (perspective.getGeyser() != null);
            this.session.camera().forceCameraPerspective(perspective.getGeyser());
        }
    }

    @Generated
    public boolean isAdjustCooldownWithPing() {
        return this.adjustCooldownWithPing;
    }

    @Generated
    public void setAdjustCooldownWithPing(boolean adjustCooldownWithPing) {
        this.adjustCooldownWithPing = adjustCooldownWithPing;
    }

    @Generated
    public float getIndicatorUpdateRate() {
        return this.indicatorUpdateRate;
    }

    @Generated
    public void setIndicatorUpdateRate(float indicatorUpdateRate) {
        this.indicatorUpdateRate = indicatorUpdateRate;
    }

    @Generated
    public Menus getSettingsMenuForm() {
        return this.settingsMenuForm;
    }

    @Generated
    public void setSettingsMenuForm(Menus settingsMenuForm) {
        this.settingsMenuForm = settingsMenuForm;
    }

    @Generated
    public boolean isEnableDoubleClickShortcut() {
        return this.enableDoubleClickShortcut;
    }

    @Generated
    public void setEnableDoubleClickShortcut(boolean enableDoubleClickShortcut) {
        this.enableDoubleClickShortcut = enableDoubleClickShortcut;
    }

    @Generated
    public int getDoubleClickMS() {
        return this.doubleClickMS;
    }

    @Generated
    public void setDoubleClickMS(int doubleClickMS) {
        this.doubleClickMS = doubleClickMS;
    }

    @Generated
    public boolean isPromptOnLinks() {
        return this.promptOnLinks;
    }

    @Generated
    public void setPromptOnLinks(boolean promptOnLinks) {
        this.promptOnLinks = promptOnLinks;
    }

    @Generated
    public Perspectives getLockedPerspective() {
        return this.lockedPerspective;
    }

    @Generated
    public List<UUID> getSelectedPacks() {
        return this.selectedPacks;
    }

    @Generated
    public void setSelectedPacks(List<UUID> selectedPacks) {
        this.selectedPacks = selectedPacks;
    }

    @Generated
    public HashMap<UUID, String> getSelectedSubpacks() {
        return this.selectedSubpacks;
    }

    @Generated
    public void setSelectedSubpacks(HashMap<UUID, String> selectedSubpacks) {
        this.selectedSubpacks = selectedSubpacks;
    }

    @Generated
    public boolean isSendSystemToasts() {
        return this.sendSystemToasts;
    }

    @Generated
    public void setSendSystemToasts(boolean sendSystemToasts) {
        this.sendSystemToasts = sendSystemToasts;
    }

    @Generated
    public boolean isShowFPS() {
        return this.showFPS;
    }

    @Generated
    public void setShowFPS(boolean showFPS) {
        this.showFPS = showFPS;
    }
}

