/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.parity.java.menus.packs;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.form.BedrockMenu;
import dev.letsgoaway.geyserextras.core.form.elements.Button;
import dev.letsgoaway.geyserextras.core.parity.java.menus.packs.PackLoader;
import dev.letsgoaway.geyserextras.core.parity.java.menus.packs.PackManagerMenu;
import java.util.List;
import java.util.UUID;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.geyser.api.pack.ResourcePack;

public class PackMenu
extends BedrockMenu {
    private boolean openingSubMenu = false;

    @Override
    public SimpleForm create(ExtrasPlayer player) {
        this.setTitle("%menu.resourcepacks");
        this.add(new Button("\u00a7l" + player.translate("pack.selected.title"), () -> player.sendForm(new PackMenu())));
        List<UUID> selectedPacks = player.getPreferences().getSelectedPacks();
        for (UUID uuid2 : selectedPacks) {
            this.createPackButton(PackLoader.PACKS.get(uuid2), player);
        }
        this.add(new Button("\u00a7l" + player.translate("pack.available.title"), () -> player.sendForm(new PackMenu())));
        PackLoader.PACKS.forEach((uuid, pack) -> {
            if (!selectedPacks.contains(uuid)) {
                this.createPackButton((ResourcePack)pack, player);
            }
        });
        return super.create(player);
    }

    @Override
    public void onClose(ExtrasPlayer player) {
        super.onClose(player);
        if (!this.openingSubMenu && player.isPacksUpdated()) {
            player.getPreferences().save();
            player.reconnect();
        }
    }

    private void createPackButton(ResourcePack pack, ExtrasPlayer player) {
        this.add(new Button(pack.manifest().header().name(), () -> {
            this.openingSubMenu = true;
            player.sendForm(new PackManagerMenu(pack));
        }));
    }
}

