/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core;

import dev.letsgoaway.geyserextras.InitializeLogger;
import dev.letsgoaway.geyserextras.Server;
import dev.letsgoaway.geyserextras.ServerType;
import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.cache.Cache;
import dev.letsgoaway.geyserextras.core.cache.PackCacheUtils;
import dev.letsgoaway.geyserextras.core.config.ConfigLoader;
import dev.letsgoaway.geyserextras.core.config.GeyserExtrasConfig;
import dev.letsgoaway.geyserextras.core.injectors.GeyserHandler;
import dev.letsgoaway.geyserextras.core.parity.bedrock.EmoteUtils;
import dev.letsgoaway.geyserextras.core.preferences.JavaPreferencesData;
import dev.letsgoaway.geyserextras.core.preferences.PreferencesData;
import dev.letsgoaway.geyserextras.core.utils.IdUtils;
import dev.letsgoaway.geyserextras.core.utils.IsAvailable;
import dev.letsgoaway.geyserextras.core.version.PluginVersion;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.bedrock.ClientEmoteEvent;
import org.geysermc.geyser.api.event.bedrock.SessionDisconnectEvent;
import org.geysermc.geyser.api.event.bedrock.SessionJoinEvent;
import org.geysermc.geyser.api.event.bedrock.SessionLoadResourcePacksEvent;
import org.geysermc.geyser.api.event.bedrock.SessionLoginEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPreReloadEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserShutdownEvent;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserExtras
implements EventRegistrar {
    public static GeyserExtras GE;
    public static Server SERVER;
    public GeyserApi geyserApi;
    public ConcurrentHashMap<String, ExtrasPlayer> connections;
    public ConcurrentHashMap<UUID, JavaPreferencesData> javaConnections;
    private GeyserExtrasConfig config;

    public GeyserExtras(Server server) {
        GE = this;
        SERVER = server;
        ServerType.platformType = GeyserImpl.getInstance().getPlatformType();
        IsAvailable.preload();
        InitializeLogger.start();
        if (!IsAvailable.cloudburst()) {
            SERVER.warn("!ERROR! GeyserExtras currently does not support running as an extension on modded platforms. !ERROR!");
            SERVER.warn("Please use Geyser-Standalone!");
            InitializeLogger.endNoDone();
            return;
        }
        this.geyserApi = GeyserApi.api();
        SERVER.log("Loading config...");
        ConfigLoader.load();
        SERVER.onConfigLoad();
        if (ServerType.isExtension()) {
            GeyserHandler.register();
            SERVER.log("Initializing cache...");
            Cache.initialize();
            SERVER.log("Loading Emote Data...");
            EmoteUtils.initialize();
        }
        PreferencesData.init();
        SERVER.log("Registering events...");
        this.geyserApi.eventBus().register((Object)this, (Object)this);
        this.geyserApi.eventBus().subscribe((Object)this, GeyserPostInitializeEvent.class, this::onGeyserInitialize);
        this.geyserApi.eventBus().subscribe((Object)this, SessionLoginEvent.class, this::onSessionLogin);
        this.geyserApi.eventBus().subscribe((Object)this, SessionJoinEvent.class, this::onSessionJoin);
        this.geyserApi.eventBus().subscribe((Object)this, SessionDisconnectEvent.class, this::onSessionRemove);
        this.geyserApi.eventBus().subscribe((Object)this, ClientEmoteEvent.class, this::onEmoteEvent);
        this.geyserApi.eventBus().subscribe((Object)this, GeyserPreReloadEvent.class, this::onGeyserReload);
        this.geyserApi.eventBus().subscribe((Object)this, GeyserShutdownEvent.class, this::onGeyserShutdown);
        this.geyserApi.eventBus().subscribe((Object)this, SessionLoadResourcePacksEvent.class, this::onLoadPacks);
        this.connections = new ConcurrentHashMap();
        this.javaConnections = new ConcurrentHashMap();
        if (ServerType.isExtension()) {
            InitializeLogger.end();
        }
        PluginVersion.checkForUpdatesAndPrintToLog();
    }

    public void serverTick() {
        for (ExtrasPlayer player : this.connections.values()) {
            if (!player.isLoggedIn()) continue;
            player.tick();
        }
    }

    public void onGeyserInitialize(GeyserPostInitializeEvent init) {
        if (!ServerType.isExtension()) {
            GeyserHandler.register();
            SERVER.log("Initializing cache...");
            Cache.initialize();
            SERVER.log("Loading Emote Data...");
            EmoteUtils.initialize();
            InitializeLogger.end();
        }
    }

    public void onSessionLogin(SessionLoginEvent ev) {
    }

    public void onSessionJoin(SessionJoinEvent ev) {
        this.connections.get(ev.connection().xuid()).startGame();
    }

    public void onSessionRemove(SessionDisconnectEvent ev) {
        GeyserConnection connection = ev.connection();
        for (ExtrasPlayer player : this.connections.values()) {
            GeyserSession session = player.getSession();
            if (!session.bedrockUsername().equals(connection.bedrockUsername())) continue;
            if (session.getAuthData() == null && session.getClientData() == null) {
                player.getPreferences().getSelectedPacks().clear();
                player.getPreferences().save();
            }
            if (GE.getConfig().isAutoReconnect()) {
                player.reconnect();
            }
            this.connections.get(player.getBedrockXUID()).onDisconnect();
            this.connections.remove(player.getBedrockXUID());
            return;
        }
        if (this.connections.containsKey(ev.connection().xuid())) {
            this.connections.get(ev.connection().xuid()).onDisconnect();
        }
        if (this.connections.remove(ev.connection().xuid()) == null) {
            SERVER.warn("Could not remove user.");
        }
    }

    public void onEmoteEvent(ClientEmoteEvent ev) {
        this.connections.get(ev.connection().xuid()).onEmoteEvent(ev);
    }

    public void onGeyserReload(GeyserPreReloadEvent ignored) {
        this.autoReconnectAll();
    }

    public void onGeyserShutdown(GeyserShutdownEvent ignored) {
        this.autoReconnectAll();
    }

    public void onLoadPacks(SessionLoadResourcePacksEvent ev) {
        this.connections.remove(ev.connection().xuid());
        this.connections.put(ev.connection().xuid(), SERVER.createPlayer(ev.connection()));
        PackCacheUtils.onPackLoadEvent(this.connections.get(ev.connection().xuid()), ev);
    }

    public JavaPreferencesData getJavaPreferencesData(UUID javaUUID) {
        return this.javaConnections.get(javaUUID);
    }

    public void autoReconnectAll() {
        if (this.getConfig().isAutoReconnect()) {
            for (ExtrasPlayer player : this.connections.values()) {
                player.getPreferences().save();
                player.reconnect();
            }
        }
    }

    public void onJavaPlayerJoin(UUID javaUUID) {
        if (!IdUtils.isBedrockPlayer(javaUUID)) {
            this.javaConnections.put(javaUUID, JavaPreferencesData.load(javaUUID));
        }
    }

    public void onJavaPlayerLeave(UUID javaUUID) {
        if (this.javaConnections.containsKey(javaUUID)) {
            this.javaConnections.get(javaUUID).save();
            this.javaConnections.remove(javaUUID);
        }
    }

    @Generated
    public GeyserExtrasConfig getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(GeyserExtrasConfig config) {
        this.config = config;
    }
}

