/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.form.elements;

import dev.letsgoaway.geyserextras.core.form.elements.Dropdown;
import java.util.Map;
import java.util.function.Consumer;

public class MappedDropdown<T>
extends Dropdown {
    private final Map<String, T> mappedOptions;
    private final Consumer<T> mappedOnSubmit;

    public MappedDropdown(String title, Map<String, T> options, T defaultOption, Consumer<T> mappedOnSubmit) {
        super(title, options.keySet().stream().toList(), null, null);
        this.mappedOptions = options;
        this.mappedOnSubmit = mappedOnSubmit;
        this.defaultOption = this.getDefaultOption(defaultOption);
        this.onSubmit = s -> this.mappedOnSubmit.accept(this.mappedOptions.get(s));
    }

    private String getDefaultOption(T option) {
        for (String str : this.mappedOptions.keySet()) {
            if (!option.equals(this.mappedOptions.get(str))) continue;
            return str;
        }
        return (String)this.options.get(0);
    }
}

