/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.form.elements;

import dev.letsgoaway.geyserextras.core.form.FormComponentType;
import dev.letsgoaway.geyserextras.core.form.FormElement;
import java.util.function.Consumer;
import org.checkerframework.checker.index.qual.Positive;
import org.geysermc.cumulus.component.Component;
import org.geysermc.cumulus.component.SliderComponent;

public class Slider
extends FormElement {
    public String title;
    public float min;
    public float max;
    public float step;
    public float defaultValue;
    public Consumer<Float> onResult;

    public Slider(String title, float min, float max, @Positive float step, float defaultValue, Consumer<Float> onResult) {
        this.title = title;
        this.min = min;
        this.max = max;
        this.step = step;
        this.defaultValue = defaultValue;
        this.onResult = onResult;
    }

    public Slider(String title, float min, float max, @Positive float step, Consumer<Float> onResult) {
        this.title = title;
        this.min = min;
        this.max = max;
        this.step = step;
        this.defaultValue = max / 2.0f;
        this.onResult = onResult;
    }

    @Override
    public FormComponentType getType() {
        return FormComponentType.SLIDER;
    }

    @Override
    public void resultRecieved(Object ... args) {
        this.onResult.accept(Float.valueOf(((Float)args[0]).floatValue()));
    }

    @Override
    public Component getComponent() {
        return SliderComponent.of((String)this.title, (float)this.min, (float)this.max, (float)this.step, (float)this.defaultValue);
    }
}

