/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.parity.bedrock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.parity.bedrock.EmoteRarity;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.UUID;

public class EmoteUtils {
    private static final Random emoteRandom = new Random();
    public static float EMOTE_DISTANCE = 100.0f;
    public static JsonObject emotes;

    public static void initialize() {
        InputStream stream = EmoteUtils.class.getClassLoader().getResourceAsStream("emotes.json");
        if (stream != null) {
            try {
                String json = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                emotes = JsonParser.parseString((String)json).getAsJsonObject();
            }
            catch (IOException e) {
                GeyserExtras.SERVER.warn("Could not load emotes!");
            }
        } else {
            GeyserExtras.SERVER.warn("Could not load emotes!");
        }
    }

    public static String getName(UUID uuid) {
        JsonElement obj = emotes.get(uuid.toString());
        if (obj == null) {
            return null;
        }
        return obj.getAsJsonObject().get("name").getAsString();
    }

    private static String getString(UUID uuid, String string) {
        JsonElement elem = emotes.get(uuid.toString());
        if (elem == null) {
            return null;
        }
        JsonObject obj = elem.getAsJsonObject();
        if (obj.get(string) == null) {
            return null;
        }
        return obj.get(string).getAsString();
    }

    public static String getThumbnail(UUID uuid) {
        return EmoteUtils.getString(uuid, "thumbnail");
    }

    public static String getCreator(UUID uuid) {
        return EmoteUtils.getString(uuid, "creator");
    }

    public static String getPrimary(UUID uuid) {
        return EmoteUtils.getString(uuid, "primary");
    }

    public static int getPrice(UUID uuid) {
        JsonElement elem = emotes.get(uuid.toString());
        if (elem == null) {
            return -1;
        }
        JsonObject obj = elem.getAsJsonObject();
        if (obj.get("price") == null) {
            return -1;
        }
        return obj.get("price").getAsInt();
    }

    public static EmoteRarity getRarity(UUID uuid) {
        JsonElement elem = emotes.get(uuid.toString());
        if (elem == null) {
            return null;
        }
        JsonObject obj = elem.getAsJsonObject();
        if (obj.get("rarity") == null) {
            return null;
        }
        return switch (obj.get("rarity").getAsString()) {
            case "UNCOMMON" -> EmoteRarity.UNCOMMON;
            case "RARE" -> EmoteRarity.RARE;
            case "EPIC" -> EmoteRarity.EPIC;
            default -> EmoteRarity.COMMON;
        };
    }

    private static String getEmoteChatRaw(UUID uuid) {
        return EmoteUtils.getEmoteChatRaw(uuid, EmoteTextType.RANDOM);
    }

    private static String getEmoteChatRaw(UUID uuid, EmoteTextType type) {
        JsonElement element = emotes.get(uuid.toString());
        if (element == null) {
            return null;
        }
        JsonObject obj = element.getAsJsonObject();
        JsonElement message = obj.get("message");
        if (message == null) {
            return null;
        }
        switch (type) {
            case RANDOM: {
                if (emoteRandom.nextInt(0, 16) == 4) {
                    return obj.get("specialmessage").getAsString();
                }
                return message.getAsString();
            }
            case MESSAGE: {
                return message.getAsString();
            }
            case SPECIAL_MESSAGE: {
                return obj.get("specialmessage").getAsString();
            }
        }
        return null;
    }

    public static String getEmoteChatString(UUID uuid, ExtrasPlayer player) {
        return EmoteUtils.getEmoteChatString(uuid, player, EmoteTextType.RANDOM);
    }

    public static String getEmoteChatString(UUID uuid, ExtrasPlayer player, EmoteTextType type) {
        char[] parsed;
        String raw = EmoteUtils.getEmoteChatRaw(uuid, type);
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        raw = raw.replace("@p", player.getSession().javaUsername());
        raw = raw.replace("@", player.getSession().javaUsername());
        int amountOfAmpersand = 0;
        int i = 0;
        for (char charRealSmooth : parsed = raw.toCharArray()) {
            if (charRealSmooth == '&' || charRealSmooth == '$') {
                if (++amountOfAmpersand == 1) {
                    parsed[i] = 57345;
                } else if (amountOfAmpersand == 2) {
                    parsed[i] = 57346;
                }
            }
            ++i;
        }
        raw = new String(parsed);
        raw = raw.replace("\ue001", "\u00a7r\u00a7a");
        raw = raw.replace("\ue002", "\u00a7r");
        return raw;
    }

    public static enum EmoteTextType {
        RANDOM,
        SPECIAL_MESSAGE,
        MESSAGE;

    }
}

