/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.utils;

import dev.letsgoaway.geyserextras.ServerType;

public class IsAvailable {
    private static boolean FLOODGATE = false;
    private static boolean CLOUDBURST = false;
    private static boolean ADVENTURE = false;
    private static boolean PACKETEVENTS = false;

    public static boolean classExists(String clazz) {
        try {
            Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static void preload() {
        FLOODGATE = IsAvailable.classExists("org.geysermc.floodgate.api.SimpleFloodgateApi");
        CLOUDBURST = IsAvailable.classExists("org.cloudburstmc.protocol.bedrock.packet.BedrockPacket");
        ADVENTURE = IsAvailable.classExists("org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component") || IsAvailable.classExists("org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component") || IsAvailable.classExists("org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component");
        PACKETEVENTS = IsAvailable.classExists("com.github.retrooper.packetevents.PacketEvents");
    }

    public static boolean floodgate() {
        if (ServerType.type == ServerType.BUNGEECORD || ServerType.type == ServerType.EXTENSION) {
            return false;
        }
        return FLOODGATE;
    }

    public static boolean cloudburst() {
        return CLOUDBURST;
    }

    public static boolean adventure() {
        return ADVENTURE;
    }

    public static boolean packetevents() {
        return IsAvailable.classExists("com.github.retrooper.packetevents.PacketEvents");
    }
}

