/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public final class ReflectionAPI {
    private static boolean staticFinalModificationBlocked;
    private static final Unsafe unsafe;

    public static Field getField(Class clazz, String fieldname) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldname);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    public static boolean hasField(Class clazz, String fieldname) {
        return ReflectionAPI.getField(clazz, fieldname) != null;
    }

    public static Field getFieldAccessible(Class clazz, String fieldname) {
        Field field = ReflectionAPI.getField(clazz, fieldname);
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    public static void setFieldNotFinal(Field field) {
        int modifiers = field.getModifiers();
        if (!Modifier.isFinal(modifiers)) {
            return;
        }
        if (staticFinalModificationBlocked) {
            try {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field classField : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(classField.getName())) continue;
                    classField.setAccessible(true);
                    classField.set(field, modifiers & 0xFFFFFFEF);
                }
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
            }
        } else {
            ReflectionAPI.setValuePrintException(Field.class, field, "modifiers", modifiers & 0xFFFFFFEF);
        }
    }

    private static void setJava16Field(Object object, Field field, Object result) {
        long offset;
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        long l = offset = isStatic ? unsafe.staticFieldOffset(field) : unsafe.objectFieldOffset(field);
        if (isStatic) {
            unsafe.putObject(unsafe.staticFieldBase(field), offset, result);
        } else {
            unsafe.putObject(object, offset, result);
        }
    }

    public static <E> Constructor<E> getEmptyConstructor(Class<E> clazz) {
        try {
            return ReflectionAPI.getConstructor(clazz, Object.class.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <E> Constructor<E> getConstructor(Class<E> clazz, Constructor<? super E> superConstructor) {
        return ReflectionFactory.getReflectionFactory().newConstructorForSerialization(clazz, superConstructor);
    }

    public static <E> E getEmptyObject(Class<E> clazz) {
        Constructor<E> constructor = ReflectionAPI.getEmptyConstructor(clazz);
        try {
            return clazz.cast(constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <O, E extends O> E copyAndExtendObject(O object, Class<E> clazz) {
        if (!object.getClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not compatible to " + object.getClass().getName());
        }
        E copy = ReflectionAPI.getEmptyObject(clazz);
        Class<?> current = object.getClass();
        do {
            for (Field f : current.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                if (Modifier.isFinal(modifiers)) {
                    ReflectionAPI.setFieldNotFinal(f);
                }
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                try {
                    f.set(copy, f.get(object));
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            }
        } while ((current = current.getSuperclass()) != Object.class);
        return copy;
    }

    public static <E> E invokeMethod(Object object, Method method, Class<E> returnType, Object ... params) {
        try {
            return (E)method.invoke(object, params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <E> E invokeMethod(Method method, Class<E> returnType, Object ... params) {
        return ReflectionAPI.invokeMethod(null, method, returnType, params);
    }

    public static <E> E invokeMethod(Object object, Method method, Object ... params) {
        try {
            return (E)method.invoke(object, params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <E> E invokeMethod(Method method, Object ... params) {
        return ReflectionAPI.invokeMethod(null, method, params);
    }

    public static Method getMethod(Class clazz, String methodname, Class<?> ... params) throws NoSuchMethodException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        NoSuchMethodException exception = null;
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodname, params);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException ex) {
                exception = ex;
                clazz = clazz.getSuperclass();
            }
        }
        if (exception != null) {
            throw exception;
        }
        throw new IllegalStateException();
    }

    public static Method getMethodPrintException(Class clazz, String methodname, Class<?> ... params) {
        try {
            return ReflectionAPI.getMethod(clazz, methodname, params);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Method getMethodOrNull(Class clazz, String methodname, Class<?> ... params) {
        try {
            return ReflectionAPI.getMethod(clazz, methodname, params);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static <E> E getValue(Class clazz, Object object, String fieldname) throws NoSuchFieldException, IllegalAccessException {
        return (E)ReflectionAPI.getFieldAccessible(clazz, fieldname).get(object);
    }

    public static <E> E getValue(Object object, String fieldname) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionAPI.getValue(object.getClass(), object, fieldname);
    }

    public static <E> E getValue(Class clazz, String fieldname) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionAPI.getValue(clazz, null, fieldname);
    }

    public static <E> E getValue(Field field) throws IllegalAccessException {
        return (E)field.get(null);
    }

    public static <E> E getValue(Object object, Field field) throws IllegalAccessException {
        return (E)field.get(object);
    }

    public static <E> E getValuePrintException(Class clazz, Object object, String fieldname) {
        try {
            return ReflectionAPI.getValue(clazz, object, fieldname);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <E> E getValuePrintException(Object object, String fieldname) {
        try {
            return ReflectionAPI.getValue(object, fieldname);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <E> E getValuePrintException(Class clazz, String fieldname) {
        try {
            return ReflectionAPI.getValue(clazz, fieldname);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <E> E getValuePrintException(Field field) {
        try {
            return (E)field.get(null);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <E> E getValuePrintException(Object object, Field field) {
        try {
            return (E)field.get(object);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <E> E getValueIgnoreException(Class clazz, Object object, String fieldname) {
        try {
            return ReflectionAPI.getValue(clazz, object, fieldname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <E> E getValueIgnoreException(Object object, String fieldname) {
        try {
            return ReflectionAPI.getValue(object, fieldname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <E> E getValueIgnoreException(Class clazz, String fieldname) {
        try {
            return ReflectionAPI.getValue(clazz, fieldname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <E> E getValueIgnoreException(Field field) {
        try {
            return (E)field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static <E> E getValueIgnoreException(Object object, Field field) {
        try {
            return (E)field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static void setValue(Class clazz, Object object, String fieldname, Object value, boolean isFinal) throws NoSuchFieldException, IllegalAccessException {
        Field field = ReflectionAPI.getFieldAccessible(clazz, fieldname);
        if (isFinal) {
            ReflectionAPI.setFieldNotFinal(field);
        }
        field.set(object, value);
    }

    public static void setValue(Class clazz, Object object, String fieldname, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionAPI.setValue(clazz, object, fieldname, value, false);
    }

    public static void setValue(Object object, String fieldname, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionAPI.setValue(object.getClass(), object, fieldname, value, false);
    }

    public static void setValue(Class clazz, String fieldname, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionAPI.setValue(clazz, null, fieldname, value, false);
    }

    public static void setValue(Field field, Object value) throws IllegalAccessException {
        field.set(null, value);
    }

    public static void setValue(Object object, Field field, Object value) throws IllegalAccessException {
        field.set(object, value);
    }

    public static void setFinalValue(Class clazz, Object object, String fieldname, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionAPI.setValue(clazz, object, fieldname, value, true);
    }

    public static void setFinalValue(Object object, String fieldname, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionAPI.setValue(object.getClass(), object, fieldname, value, true);
    }

    public static void setFinalValue(Class clazz, String fieldname, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionAPI.setValue(clazz, null, fieldname, value, true);
    }

    public static void setFinalValue(Field field, Object value) throws IllegalAccessException {
        if (unsafe != null) {
            ReflectionAPI.setJava16Field(null, field, value);
        } else {
            ReflectionAPI.setFieldNotFinal(field);
            field.set(null, value);
        }
    }

    public static void setFinalValue(Object object, Field field, Object value) throws IllegalAccessException {
        ReflectionAPI.setFieldNotFinal(field);
        field.set(object, value);
    }

    public static void setValuePrintException(Class clazz, Object object, String fieldname, Object value) {
        try {
            ReflectionAPI.setValue(clazz, object, fieldname, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setValuePrintException(Object object, String fieldname, Object value) {
        try {
            ReflectionAPI.setValue(object, fieldname, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setValuePrintException(Class clazz, String fieldname, Object value) {
        try {
            ReflectionAPI.setValue(clazz, fieldname, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setValuePrintException(Field field, Object value) {
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    public static void setValuePrintException(Object object, Field field, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    public static void setFinalValuePrintException(Class clazz, Object object, String fieldname, Object value) {
        try {
            ReflectionAPI.setFinalValue(clazz, object, fieldname, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setFinalValuePrintException(Object object, String fieldname, Object value) {
        try {
            ReflectionAPI.setFinalValue(object, fieldname, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setFinalValuePrintException(Class clazz, String fieldname, Object value) {
        try {
            ReflectionAPI.setFinalValue(clazz, fieldname, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setFinalValuePrintException(Field field, Object value) {
        ReflectionAPI.setFieldNotFinal(field);
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    public static void setFinalValuePrintException(Object object, Field field, Object value) {
        ReflectionAPI.setFieldNotFinal(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    public static void setValueIgnoreException(Class clazz, Object object, String fieldname, Object value) {
        try {
            ReflectionAPI.setValue(clazz, object, fieldname, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setValueIgnoreException(Object object, String fieldname, Object value) {
        try {
            ReflectionAPI.setValue(object, fieldname, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setValueIgnoreException(Class clazz, String fieldname, Object value) {
        try {
            ReflectionAPI.setValue(clazz, fieldname, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setValueIgnoreException(Field field, Object value) {
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void setValueIgnoreException(Object object, Field field, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void setFinalValueIgnoreException(Class clazz, Object object, String fieldname, Object value) {
        try {
            ReflectionAPI.setFinalValue(clazz, object, fieldname, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFinalValueIgnoreException(Object object, String fieldname, Object value) {
        try {
            ReflectionAPI.setFinalValue(object, fieldname, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFinalValueIgnoreException(Class clazz, String fieldname, Object value) {
        try {
            ReflectionAPI.setFinalValue(clazz, fieldname, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFinalValueIgnoreException(Field field, Object value) {
        ReflectionAPI.setFieldNotFinal(field);
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void setFinalValueIgnoreException(Object object, Field field, Object value) {
        ReflectionAPI.setFieldNotFinal(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    static {
        boolean isJava16;
        try {
            Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException ex) {
            staticFinalModificationBlocked = true;
        }
        boolean bl = isJava16 = Float.parseFloat(System.getProperty("java.class.version")) >= 60.0f;
        if (isJava16) {
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                unsafe = (Unsafe)unsafeField.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            unsafe = null;
        }
    }
}

