/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.spigot;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.spigot.GeyserExtrasSpigot;
import dev.letsgoaway.geyserextras.spigot.SpigotExtrasPlayer;
import java.util.Arrays;
import java.util.List;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class SpigotListener
implements Listener {
    public static final List<String> cropTypes = Arrays.asList("WHEAT", "WHEAT_SEEDS", "SEEDS", "CROPS", "CARROT", "CARROTS", "CARROT_ITEM", "POTATO", "POTATOES", "POTATO_ITEM", "BEETROOT", "BEETROOT_SEEDS", "BEETROOT_BLOCK", "BEETROOTS", "MELON_SEEDS", "MELON_STEM", "PUMPKIN_SEEDS", "PUMPKIN_STEM");

    public static void stopSoundForBlock(String blockName, Player player) {
        player.stopSound("minecraft:dig." + blockName);
        player.stopSound("minecraft:use." + blockName);
        player.stopSound("minecraft:step." + blockName);
        player.stopSound("minecraft:land." + blockName);
        player.stopSound("minecraft:jump." + blockName);
        player.stopSound("minecraft:hit." + blockName);
        player.stopSound("minecraft:fall." + blockName);
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        GeyserExtrasSpigot.CORE.onJavaPlayerJoin(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onPlayerLeave(event.getPlayer());
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        this.onPlayerLeave(event.getPlayer());
    }

    @EventHandler
    public void onPlayerBlockPlace(BlockPlaceEvent ev) {
        Player player = ev.getPlayer();
        ExtrasPlayer user = ExtrasPlayer.get(player.getUniqueId());
        if (user instanceof SpigotExtrasPlayer) {
            SpigotExtrasPlayer extrasPlayer = (SpigotExtrasPlayer)user;
            if (GeyserExtrasSpigot.SPIGOT.getPlatformConfig().isEnableJavaOnlyBlockPlacement()) {
                Block block = ev.getBlockPlaced();
                double interactionRange = extrasPlayer.getSession().getPlayerEntity().getBlockInteractionRange();
                if (block.getType().equals((Object)Material.AIR) || ev.getBlockAgainst().getType().equals((Object)Material.AIR)) {
                    ev.setCancelled(true);
                } else {
                    RayTraceResult blockCast = player.rayTraceBlocks(interactionRange, FluidCollisionMode.ALWAYS);
                    if (blockCast != null) {
                        ev.setCancelled(!block.equals(blockCast.getHitBlock()));
                    }
                }
                if (ev.isCancelled()) {
                    block.setType(Material.AIR);
                    Vector velocity = player.getVelocity().clone();
                    player.teleport(player.getLocation());
                    GeyserExtras.SERVER.getTickUtil().runIn(2L, () -> player.setVelocity(velocity), extrasPlayer);
                    player.updateInventory();
                }
            }
        }
    }

    private void cropStop(Player player) {
        SpigotListener.stopSoundForBlock("grass", player);
        SpigotListener.stopSoundForBlock("gravel", player);
        SpigotListener.stopSoundForBlock("dirt", player);
        player.stopSound("minecraft:block.crop.break");
        player.stopSound("minecraft:item.crop.plant");
    }

    public void onPlayerLeave(Player player) {
        GeyserExtrasSpigot.CORE.onJavaPlayerLeave(player.getUniqueId());
    }
}

