/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.spigot.config;

import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.spigot.GeyserExtrasSpigot;
import dev.letsgoaway.geyserextras.spigot.config.GeyserExtrasSpigotConfig;
import dev.letsgoaway.relocate.org.spongepowered.configurate.CommentedConfigurationNode;
import dev.letsgoaway.relocate.org.spongepowered.configurate.ConfigurateException;
import dev.letsgoaway.relocate.org.spongepowered.configurate.loader.HeaderMode;
import dev.letsgoaway.relocate.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.NodeStyle;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import java.nio.file.Path;

public class SpigotConfigLoader {
    public static final int LATEST_VERSION = 1;
    private static final String HEADER = "GeyserExtras - Spigot Configuration\n";
    private static final ConfigurationTransformation.Versioned transformer = ConfigurationTransformation.versionedBuilder().addVersion(1, SpigotConfigLoader.zeroToOne()).build();

    public static void load() {
        Path configPath = GeyserExtras.SERVER.getPluginFolder().resolve("spigot.yml");
        boolean existingConfig = configPath.toFile().exists();
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESERVE)).defaultOptions(options -> options.header(HEADER))).build();
        try {
            CommentedConfigurationNode configurationNode = (CommentedConfigurationNode)loader.load();
            int currentVersion = transformer.version(configurationNode);
            if (currentVersion != 1) {
                transformer.apply(configurationNode);
            }
            GeyserExtrasSpigotConfig config = configurationNode.get(GeyserExtrasSpigotConfig.class);
            CommentedConfigurationNode newNode = CommentedConfigurationNode.root(loader.defaultOptions());
            newNode.set(GeyserExtrasSpigotConfig.class, (Object)config);
            if (!existingConfig || currentVersion != 1) {
                loader.save(newNode);
            }
            GeyserExtrasSpigot.SPIGOT.setPlatformConfig(config);
        }
        catch (ConfigurateException e) {
            GeyserExtras.SERVER.warn("Failed to load spigot config! Using defaults.\n" + e.getMessage());
            GeyserExtrasSpigot.SPIGOT.setPlatformConfig(new GeyserExtrasSpigotConfig());
        }
    }

    private static ConfigurationTransformation zeroToOne() {
        return ConfigurationTransformation.builder().build();
    }
}

