/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.relocate.org.spongepowered.configurate.reactive;

import dev.letsgoaway.relocate.org.spongepowered.configurate.reactive.Disposable;
import dev.letsgoaway.relocate.org.spongepowered.configurate.reactive.NoOpDisposable;
import dev.letsgoaway.relocate.org.spongepowered.configurate.reactive.Publisher;
import dev.letsgoaway.relocate.org.spongepowered.configurate.reactive.Subscriber;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class CachedPublisher<V>
implements Publisher.Cached<V>,
AutoCloseable {
    private final Publisher<V> parent;
    private final Set<Subscriber<? super V>> subscribers = ConcurrentHashMap.newKeySet();
    private volatile @MonotonicNonNull V value;
    private final Disposable closer;

    CachedPublisher(Publisher<V> parent, @Nullable V initialValue) {
        this.parent = parent;
        if (initialValue != null) {
            this.value = initialValue;
        }
        this.closer = this.parent.subscribe(next -> {
            this.value = next;
        });
    }

    @Override
    public Disposable subscribe(Subscriber<? super V> subscriber) {
        Disposable disp = this.parent.subscribe(subscriber);
        if (disp != NoOpDisposable.INSTANCE) {
            this.subscribers.add(subscriber);
            V value = this.value;
            if (value != null) {
                subscriber.submit(value);
            }
            return () -> {
                this.subscribers.remove(subscriber);
                disp.dispose();
            };
        }
        return disp;
    }

    @Override
    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    @Override
    public Publisher.Cached<V> cache() {
        return this;
    }

    @Override
    public Publisher.Cached<V> cache(@Nullable V initialValue) {
        if (this.value == null && initialValue != null) {
            this.value = initialValue;
        }
        return this;
    }

    @Override
    public Executor executor() {
        return this.parent.executor();
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public void submit(V value) {
        this.value = value;
        this.subscribers.forEach(it -> it.submit(value));
    }

    @Override
    public void close() {
        this.closer.dispose();
    }
}

