/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.relocate.org.spongepowered.configurate.serialize;

import dev.letsgoaway.io.leangen.geantyref.TypeToken;
import dev.letsgoaway.relocate.org.spongepowered.configurate.ConfigurationNode;
import dev.letsgoaway.relocate.org.spongepowered.configurate.ConfigurationOptions;
import dev.letsgoaway.relocate.org.spongepowered.configurate.serialize.SerializationException;
import dev.letsgoaway.relocate.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.checkerframework.checker.nullness.qual.Nullable;

final class OptionalSerializer
implements TypeSerializer.Annotated<Optional<?>> {
    static final TypeToken<Optional<?>> TYPE = new TypeToken<Optional<?>>(){};
    static final TypeSerializer<Optional<?>> INSTANCE = new OptionalSerializer();

    private OptionalSerializer() {
    }

    private static AnnotatedType extractParameter(AnnotatedType optional) throws SerializationException {
        if (!(optional instanceof AnnotatedParameterizedType)) {
            throw new SerializationException(optional, "Required type parameters on annotated type");
        }
        return ((AnnotatedParameterizedType)optional).getAnnotatedActualTypeArguments()[0];
    }

    @Override
    public Optional<?> deserialize(AnnotatedType type, ConfigurationNode node) throws SerializationException {
        if (node.empty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(node.get(OptionalSerializer.extractParameter(type)));
    }

    @Override
    public void serialize(AnnotatedType type, @Nullable Optional<?> obj, ConfigurationNode node) throws SerializationException {
        if (obj == null || !obj.isPresent()) {
            node.set(null);
            return;
        }
        node.set(OptionalSerializer.extractParameter(type), obj.get());
    }

    @Override
    public Optional<?> emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
        return Optional.empty();
    }

    static final class OfDouble
    implements TypeSerializer<OptionalDouble> {
        static final Class<OptionalDouble> TYPE = OptionalDouble.class;
        static final TypeSerializer<OptionalDouble> INSTANCE = new OfDouble();

        private OfDouble() {
        }

        @Override
        public OptionalDouble deserialize(Type type, ConfigurationNode node) throws SerializationException {
            if (node.empty()) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(node.require(Double.TYPE));
        }

        @Override
        public void serialize(Type type, @Nullable OptionalDouble obj, ConfigurationNode node) throws SerializationException {
            if (obj == null || !obj.isPresent()) {
                node.set(null);
                return;
            }
            node.set(Double.TYPE, Double.valueOf(obj.getAsDouble()));
        }

        @Override
        public OptionalDouble emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
            return OptionalDouble.empty();
        }
    }

    static final class OfLong
    implements TypeSerializer<OptionalLong> {
        static final Class<OptionalLong> TYPE = OptionalLong.class;
        static final TypeSerializer<OptionalLong> INSTANCE = new OfLong();

        private OfLong() {
        }

        @Override
        public OptionalLong deserialize(Type type, ConfigurationNode node) throws SerializationException {
            if (node.empty()) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(node.require(Long.TYPE));
        }

        @Override
        public void serialize(Type type, @Nullable OptionalLong obj, ConfigurationNode node) throws SerializationException {
            if (obj == null || !obj.isPresent()) {
                node.set(null);
                return;
            }
            node.set(Long.TYPE, Long.valueOf(obj.getAsLong()));
        }

        @Override
        public OptionalLong emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
            return OptionalLong.empty();
        }
    }

    static final class OfInt
    implements TypeSerializer<OptionalInt> {
        static final Class<OptionalInt> TYPE = OptionalInt.class;
        static final TypeSerializer<OptionalInt> INSTANCE = new OfInt();

        private OfInt() {
        }

        @Override
        public OptionalInt deserialize(Type type, ConfigurationNode node) throws SerializationException {
            if (node.empty()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(node.require(Integer.TYPE));
        }

        @Override
        public void serialize(Type type, @Nullable OptionalInt obj, ConfigurationNode node) throws SerializationException {
            if (obj == null || !obj.isPresent()) {
                node.set(null);
                return;
            }
            node.set(Integer.TYPE, Integer.valueOf(obj.getAsInt()));
        }

        @Override
        public OptionalInt emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
            return OptionalInt.empty();
        }
    }
}

