/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.render;

import com.ventooth.beddium.Compat;
import com.ventooth.beddium.modules.TerrainRendering.render.CompatibleChunkRenderer;
import java.util.Objects;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.shader.GlProgram;
import org.embeddedt.embeddium.impl.gl.shader.ShaderBindingContext;
import org.embeddedt.embeddium.impl.gl.tessellation.GlPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.QuadPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderOptions;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderTextureSlot;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

final class SwanSongChunkRenderer
extends CompatibleChunkRenderer {
    private GlPrimitiveType primitiveType;

    SwanSongChunkRenderer(RenderDevice device, RenderPassConfiguration<?> renderPassConfiguration) {
        super(device, renderPassConfiguration);
        this.activeProgram = new SwanSongProgram(this);
        this.primitiveType = null;
    }

    @Override
    protected boolean useBlockFaceCulling() {
        return !Compat.shadowPassActive();
    }

    @Override
    protected void begin(TerrainRenderPass pass) {
        pass.startDrawing();
        this.setPrimitiveType(pass.primitiveType());
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
    }

    private void setPrimitiveType(ChunkPrimitiveType chunkPrimitiveType) {
        if (chunkPrimitiveType == QuadPrimitiveType.DIRECT) {
            this.primitiveType = GlPrimitiveType.QUADS;
        } else if (chunkPrimitiveType == QuadPrimitiveType.TRIANGULATED) {
            this.primitiveType = GlPrimitiveType.TRIANGLES;
        } else {
            throw new IllegalArgumentException("Unknown primitive type");
        }
    }

    @Override
    protected void end(TerrainRenderPass pass) {
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        pass.endDrawing();
    }

    private void setRegionOffset(float x, float y, float z) {
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
    }

    @Override
    protected GlProgram<ChunkShaderInterface> compileProgram(ChunkShaderOptions options) {
        throw new UnsupportedOperationException("Shaders managed by SwanSong");
    }

    @Override
    protected GlProgram<ChunkShaderInterface> createShader(String path, ChunkShaderOptions options) {
        throw new UnsupportedOperationException("Shaders managed by SwanSong");
    }

    @Override
    protected void configureShaderInterface(ChunkShaderInterface shader) {
    }

    private final class SwanSongProgram
    extends GlProgram<ChunkShaderInterface> {
        static final int FAKE_PROGRAM_NAME = 10000000;

        SwanSongProgram(SwanSongChunkRenderer swanSongChunkRenderer) {
            super(10000000, x$0 -> {
                SwanSongChunkRenderer swanSongChunkRenderer = swanSongChunkRenderer;
                Objects.requireNonNull(swanSongChunkRenderer);
                return swanSongChunkRenderer.new SwanSongChunkShaderInterface((ShaderBindingContext)x$0);
            });
        }

        @Override
        public void bind() {
        }

        @Override
        public void unbind() {
        }

        @Override
        protected void destroyInternal() {
        }
    }

    private final class SwanSongChunkShaderInterface
    implements ChunkShaderInterface {
        @Override
        public GlPrimitiveType getPrimitiveType() {
            if (SwanSongChunkRenderer.this.primitiveType == null) {
                throw new IllegalStateException("Primitive type not set");
            }
            return SwanSongChunkRenderer.this.primitiveType;
        }

        @Override
        public void setRegionOffset(float x, float y, float z) {
            SwanSongChunkRenderer.this.setRegionOffset(x, y, z);
        }

        @Override
        public void setProjectionMatrix(Matrix4fc matrix) {
        }

        @Override
        public void setModelViewMatrix(Matrix4fc matrix) {
        }

        private SwanSongChunkShaderInterface(ShaderBindingContext ctx) {
        }

        @Override
        public void setupState(TerrainRenderPass pass) {
        }

        @Override
        public void setTextureSlot(ChunkShaderTextureSlot slot, int val) {
        }
    }
}

