/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.vertex;

import com.ventooth.beddium.Compat;
import com.ventooth.beddium.modules.MEGAChunks.MegaChunkMetadata;
import com.ventooth.beddium.modules.TerrainRendering.vertex.DefaultChunkVertex;
import com.ventooth.beddium.modules.TerrainRendering.vertex.RPLEChunkVertex;
import com.ventooth.beddium.modules.TerrainRendering.vertex.SwanSongChunkVertex;
import com.ventooth.beddium.modules.TerrainRendering.vertex.SwanSongRPLEChunkVertex;
import java.util.Map;
import org.embeddedt.embeddium.impl.gl.array.GlVertexArray;
import org.embeddedt.embeddium.impl.gl.tessellation.GlVertexArrayTessellation;
import org.embeddedt.embeddium.impl.gl.tessellation.TessellationBinding;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;

public sealed interface CompatibleChunkVertex
extends ChunkVertexType
permits DefaultChunkVertex, RPLEChunkVertex, SwanSongChunkVertex, SwanSongRPLEChunkVertex {
    public static CompatibleChunkVertex get() {
        if (Compat.isSwansongInitialized()) {
            if (Compat.rpleInstalled()) {
                return SwanSongRPLEChunkVertex.INSTANCE;
            }
            return SwanSongChunkVertex.INSTANCE;
        }
        if (Compat.rpleInstalled()) {
            return RPLEChunkVertex.INSTANCE;
        }
        return DefaultChunkVertex.INSTANCE;
    }

    @Override
    default public float getPositionScale() {
        return 1.0f;
    }

    @Override
    default public float getPositionOffset() {
        return 0.0f;
    }

    @Override
    default public float getTextureScale() {
        return 1.0f;
    }

    public int attribStride();

    public int rawBufStride();

    public Vertex[] uninitializedQuad();

    default public Tessellation getTessellation(GlVertexArray array, TessellationBinding[] bindings) {
        return new Tessellation(array, bindings);
    }

    public static int encodeLightRPLE(int light) {
        return CompatibleChunkVertex.encodeLight(CompatibleChunkVertex.vanillaFromTess(light));
    }

    @Override
    default public Map<String, String> getDefines() {
        Map<String, String> map = ChunkVertexType.super.getDefines();
        map.put("MEGACHUNK_SIZE", Float.toString(MegaChunkMetadata.BLOCKS_PER_WR_EDGE_FLOAT));
        return map;
    }

    private static int vanillaFromTess(int tess) {
        short lightMapBlock = (short)(tess & 0xFFFF);
        short lightMapSky = (short)(tess >> 16 & 0xFFFF);
        int blockLight = CompatibleChunkVertex.remapFromShort(lightMapBlock);
        int skyLight = CompatibleChunkVertex.remapFromShort(lightMapSky);
        return blockLight | skyLight << 16;
    }

    private static int remapFromShort(short n) {
        float normalized = (float)(n - Short.MIN_VALUE) / 65535.0f;
        return Math.round(normalized * 240.0f);
    }

    public static int encodeDrawParameters(Material material, int sectionIndex) {
        return (sectionIndex & 0xFF) << 8 | (material.bits() & 0xFF) << 0;
    }

    public static int encodeLight(int light) {
        int block = light & 0xFF;
        int sky = light >> 16 & 0xFF;
        return block << 0 | sky << 8;
    }

    public static float encodeTexture(float value) {
        return Math.min(0.99999994f, value);
    }

    public static class Tessellation
    extends GlVertexArrayTessellation {
        public Tessellation(GlVertexArray array, TessellationBinding[] bindings) {
            super(array, bindings);
        }
    }

    public static abstract class Vertex
    extends ChunkVertexEncoder.Vertex {
        public abstract void copyRawBuffer(int[] var1, int var2);
    }
}

