/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.device;

import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public final class MultiDrawBatch {
    public final long pElementPointer;
    public final long pElementCount;
    public final long pBaseVertex;
    private final int capacity;
    public int size;

    public MultiDrawBatch(int capacity) {
        this.pElementPointer = MemoryUtil.nmemAlignedAlloc((long)32L, (long)((long)capacity * (long)Pointer.POINTER_SIZE));
        if (this.pElementPointer == 0L) {
            throw new OutOfMemoryError("Failed to allocate element pointer array");
        }
        MemoryUtil.memSet((long)this.pElementPointer, (int)0, (long)((long)capacity * (long)Pointer.POINTER_SIZE));
        this.pElementCount = MemoryUtil.nmemAlignedAlloc((long)32L, (long)((long)capacity * 4L));
        if (this.pElementCount == 0L) {
            MemoryUtil.nmemAlignedFree((long)this.pElementPointer);
            throw new OutOfMemoryError("Failed to allocate element count array");
        }
        this.pBaseVertex = MemoryUtil.nmemAlignedAlloc((long)32L, (long)((long)capacity * 4L));
        if (this.pBaseVertex == 0L) {
            MemoryUtil.nmemAlignedFree((long)this.pElementPointer);
            MemoryUtil.nmemAlignedFree((long)this.pElementCount);
            throw new OutOfMemoryError("Failed to allocate base vertex array");
        }
        this.capacity = capacity;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        this.size = 0;
    }

    public void delete() {
        MemoryUtil.nmemAlignedFree((long)this.pElementPointer);
        MemoryUtil.nmemAlignedFree((long)this.pElementCount);
        MemoryUtil.nmemAlignedFree((long)this.pBaseVertex);
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public int getIndexBufferSize() {
        int elements = 0;
        for (int index = 0; index < this.size; ++index) {
            elements = Math.max(elements, MemoryUtil.memGetInt((long)(this.pElementCount + (long)index * 4L)));
        }
        return elements;
    }
}

