/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.light.smooth;

import org.embeddedt.embeddium.api.util.NormI8;
import org.embeddedt.embeddium.impl.common.util.MathUtil;
import org.embeddedt.embeddium.impl.model.light.DiffuseProvider;
import org.embeddedt.embeddium.impl.model.light.LightPipeline;
import org.embeddedt.embeddium.impl.model.light.data.LightDataAccess;
import org.embeddedt.embeddium.impl.model.light.data.QuadLightData;
import org.embeddedt.embeddium.impl.model.light.smooth.AoFaceData;
import org.embeddedt.embeddium.impl.model.light.smooth.AoNeighborInfo;
import org.embeddedt.embeddium.impl.model.quad.ModelQuadView;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.util.PositionUtil;

public class SmoothLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;
    private final AoFaceData[] cachedFaceData = new AoFaceData[12];
    private long cachedPos = Long.MIN_VALUE;
    private final float[] weights = new float[4];
    private final boolean useQuadNormalsForShading;
    private final DiffuseProvider diffuseProvider;
    private float lastAo;
    private float lastBl;
    private float lastSl;
    private static final float BLENDED_WEIGHT = 0.75f;
    private static final float MAX_WEIGHT = 0.25f;

    public SmoothLightPipeline(LightDataAccess cache, DiffuseProvider diffuseProvider, boolean useQuadNormalsForShading) {
        this.lightCache = cache;
        for (int i = 0; i < this.cachedFaceData.length; ++i) {
            this.cachedFaceData[i] = new AoFaceData();
        }
        this.useQuadNormalsForShading = useQuadNormalsForShading;
        this.diffuseProvider = diffuseProvider;
    }

    @Override
    public void calculate(ModelQuadView quad, int x, int y, int z, QuadLightData out, ModelQuadFacing cullFace, ModelQuadFacing lightFace, boolean shade, boolean applyAoDepthBlending) {
        this.updateCachedData(PositionUtil.packBlock(x, y, z));
        int flags = quad.getFlags();
        AoNeighborInfo neighborInfo = AoNeighborInfo.get(lightFace);
        if ((flags & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(x, y, z))) {
            if ((flags & 1) == 0) {
                this.applyAlignedFullFace(neighborInfo, x, y, z, lightFace, out);
            } else {
                this.applyAlignedPartialFace(neighborInfo, quad, x, y, z, lightFace, out);
            }
        } else if ((flags & 8) == 0 && quad.getNormalFace() == ModelQuadFacing.UNASSIGNED) {
            this.applyIrregularFace(quad, x, y, z, out, applyAoDepthBlending);
        } else {
            this.applyNonParallelFace(neighborInfo, quad, x, y, z, lightFace, out, applyAoDepthBlending);
        }
        if ((flags & 8) != 0 || !this.useQuadNormalsForShading) {
            this.applySidedBrightness(out, lightFace, shade);
        } else {
            this.applySidedBrightnessFromNormals(out, quad, shade);
        }
    }

    @Override
    public void reset() {
        this.cachedPos = Long.MIN_VALUE;
    }

    private void applyAlignedFullFace(AoNeighborInfo neighborInfo, int x, int y, int z, ModelQuadFacing dir, QuadLightData out) {
        AoFaceData faceData = this.getCachedFaceData(x, y, z, dir, true);
        neighborInfo.mapCorners(faceData.lm, faceData.ao, out.lm, out.br);
    }

    private void applyAlignedPartialFace(AoNeighborInfo neighborInfo, ModelQuadView quad, int x, int y, int z, ModelQuadFacing dir, QuadLightData out) {
        for (int i = 0; i < 4; ++i) {
            float cx = SmoothLightPipeline.clamp(quad.getX(i));
            float cy = SmoothLightPipeline.clamp(quad.getY(i));
            float cz = SmoothLightPipeline.clamp(quad.getZ(i));
            float[] weights = this.weights;
            neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
            this.applyAlignedPartialFaceVertex(x, y, z, dir, weights, true);
            out.br[i] = this.lastAo;
            out.lm[i] = SmoothLightPipeline.getLightMapCoord(this.lastSl, this.lastBl);
        }
    }

    private void applyNonParallelFace(AoNeighborInfo neighborInfo, ModelQuadView quad, int x, int y, int z, ModelQuadFacing dir, QuadLightData out, boolean applyAoDepthBlending) {
        for (int i = 0; i < 4; ++i) {
            float cx = SmoothLightPipeline.clamp(quad.getX(i));
            float cy = SmoothLightPipeline.clamp(quad.getY(i));
            float cz = SmoothLightPipeline.clamp(quad.getZ(i));
            float[] weights = this.weights;
            neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
            float depth = neighborInfo.getDepth(cx, cy, cz);
            if (applyAoDepthBlending) {
                this.applyInsetPartialFaceVertex(x, y, z, dir, depth, 1.0f - depth, weights);
            } else {
                this.applyAlignedPartialFaceVertex(x, y, z, dir, weights, MathUtil.roughlyEqual(depth, 0.0f));
            }
            out.br[i] = this.lastAo;
            out.lm[i] = SmoothLightPipeline.getLightMapCoord(this.lastSl, this.lastBl);
        }
    }

    private void applyInsetPartialFaceVertex(int x, int y, int z, ModelQuadFacing dir, float n1d, float n2d, float[] w) {
        AoFaceData n2;
        if (MathUtil.roughlyEqual(n1d, 0.0f)) {
            this.applyAlignedPartialFaceVertex(x, y, z, dir, w, true);
            return;
        }
        if (MathUtil.roughlyEqual(n1d, 1.0f)) {
            this.applyAlignedPartialFaceVertex(x, y, z, dir, w, false);
            return;
        }
        AoFaceData n1 = this.getCachedFaceData(x, y, z, dir, false);
        if (!n1.hasUnpackedLightData()) {
            n1.unpackLightData();
        }
        if (!(n2 = this.getCachedFaceData(x, y, z, dir, true)).hasUnpackedLightData()) {
            n2.unpackLightData();
        }
        this.lastAo = n1.getBlendedShade(w) * n1d + n2.getBlendedShade(w) * n2d;
        this.lastSl = n1.getBlendedSkyLight(w) * n1d + n2.getBlendedSkyLight(w) * n2d;
        this.lastBl = n1.getBlendedBlockLight(w) * n1d + n2.getBlendedBlockLight(w) * n2d;
    }

    private void applyIrregularFace(ModelQuadView quad, int x, int y, int z, QuadLightData out, boolean applyAoDepthBlending) {
        for (int i = 0; i < 4; ++i) {
            float cx = SmoothLightPipeline.clamp(quad.getX(i));
            float cy = SmoothLightPipeline.clamp(quad.getY(i));
            float cz = SmoothLightPipeline.clamp(quad.getZ(i));
            int normal = quad.getForgeNormal(i);
            if (normal == 0) {
                normal = quad.getComputedFaceNormal();
            }
            float weightedAo = 0.0f;
            float weightedBl = 0.0f;
            float weightedSl = 0.0f;
            float maxAo = 0.0f;
            float maxBl = 0.0f;
            float maxSl = 0.0f;
            for (int axis = 0; axis < 3; ++axis) {
                float projectedNormal = NormI8.unpackX(normal >> axis * 8);
                if (projectedNormal == 0.0f) continue;
                ModelQuadFacing dir = ModelQuadFacing.AXES[axis].getFacing(projectedNormal > 0.0f);
                AoNeighborInfo neighborInfo = AoNeighborInfo.get(dir);
                float[] weights = this.weights;
                neighborInfo.calculateCornerWeights(cx, cy, cz, weights);
                float depth = neighborInfo.getDepth(cx, cy, cz);
                if (applyAoDepthBlending) {
                    this.applyInsetPartialFaceVertex(x, y, z, dir, depth, 1.0f - depth, weights);
                } else {
                    this.applyAlignedPartialFaceVertex(x, y, z, dir, weights, MathUtil.roughlyEqual(depth, 0.0f));
                }
                float ao = this.lastAo;
                float sl = this.lastSl;
                float bl = this.lastBl;
                float combineWeight = projectedNormal * projectedNormal;
                weightedAo += ao * combineWeight;
                weightedBl += bl * combineWeight;
                weightedSl += sl * combineWeight;
                maxAo = Math.max(ao, maxAo);
                maxSl = Math.max(sl, maxSl);
                maxBl = Math.max(bl, maxBl);
            }
            out.br[i] = SmoothLightPipeline.clamp(weightedAo * 0.75f + maxAo * 0.25f);
            out.lm[i] = SmoothLightPipeline.getLightMapCoord(weightedSl * 0.75f + maxSl * 0.25f, weightedBl * 0.75f + maxBl * 0.25f);
        }
    }

    private void applyAlignedPartialFaceVertex(int x, int y, int z, ModelQuadFacing dir, float[] w, boolean offset) {
        AoFaceData faceData = this.getCachedFaceData(x, y, z, dir, offset);
        if (!faceData.hasUnpackedLightData()) {
            faceData.unpackLightData();
        }
        this.lastSl = faceData.getBlendedSkyLight(w);
        this.lastBl = faceData.getBlendedBlockLight(w);
        this.lastAo = faceData.getBlendedShade(w);
    }

    private void applySidedBrightness(QuadLightData out, ModelQuadFacing face, boolean shade) {
        float brightness = this.diffuseProvider.getDiffuse(face, shade);
        float[] br = out.br;
        int i = 0;
        while (i < br.length) {
            int n = i++;
            br[n] = br[n] * brightness;
        }
    }

    private void applySidedBrightnessFromNormals(QuadLightData out, ModelQuadView quad, boolean shade) {
        int normal = quad.getModFaceNormal();
        float brightness = this.diffuseProvider.getDiffuse(NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal), shade);
        float[] br = out.br;
        int i = 0;
        while (i < br.length) {
            int n = i++;
            br[n] = br[n] * brightness;
        }
    }

    private AoFaceData getCachedFaceData(int x, int y, int z, ModelQuadFacing face, boolean offset) {
        AoFaceData data = this.cachedFaceData[offset ? face.ordinal() : face.ordinal() + 6];
        if (!data.hasLightData()) {
            data.initLightData(this.lightCache, x, y, z, face, offset);
        }
        return data;
    }

    private void updateCachedData(long key) {
        if (this.cachedPos != key) {
            for (AoFaceData data : this.cachedFaceData) {
                data.reset();
            }
            this.cachedPos = key;
        }
    }

    private static float clamp(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 1.0f) {
            return 1.0f;
        }
        return v;
    }

    private static int getLightMapCoord(float sl, float bl) {
        return ((int)sl & 0xFF) << 16 | (int)bl & 0xFF;
    }
}

