/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.occlusion;

import org.embeddedt.embeddium.impl.render.chunk.occlusion.GraphDirection;
import org.jetbrains.annotations.NotNull;

public class VisibilityEncoding {
    public static final long NULL = 0L;
    public static final long EVERYTHING = VisibilityEncoding.everything();

    public static <T> long encode(@NotNull DataHolder holder) {
        long visibilityData = 0L;
        for (int from = 0; from < 6; ++from) {
            for (int to = 0; to < 6; ++to) {
                if (!holder.canFaceSeeFace(from, to)) continue;
                visibilityData |= 1L << VisibilityEncoding.bit(from, to);
            }
        }
        return visibilityData;
    }

    static int bit(int from, int to) {
        return from * 8 + to;
    }

    private static long everything() {
        long visibilityData = 0L;
        for (int from = 0; from < 6; ++from) {
            for (int to = 0; to < 6; ++to) {
                visibilityData |= 1L << VisibilityEncoding.bit(from, to);
            }
        }
        return visibilityData;
    }

    public static int getConnections(long visibilityData, int incoming) {
        return VisibilityEncoding.foldOutgoingDirections(visibilityData & VisibilityEncoding.createMask(incoming));
    }

    public static int getConnections(long visibilityData) {
        return VisibilityEncoding.foldOutgoingDirections(visibilityData);
    }

    private static long createMask(int incoming) {
        long expanded = 34630287489L * Integer.toUnsignedLong(incoming);
        return (expanded & 0x10101010101L) * 255L;
    }

    private static int foldOutgoingDirections(long data) {
        long folded = data;
        folded |= folded >> 32;
        folded |= folded >> 16;
        folded |= folded >> 8;
        return (int)(folded & 0x3FL);
    }

    public static String stringify(long data) {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        for (char c : GraphDirection.LETTERS) {
            sb.append(c);
        }
        sb.append('\n');
        for (int from = 0; from < 6; ++from) {
            sb.append(GraphDirection.LETTERS[from]);
            sb.append('|');
            for (int to = 0; to < 6; ++to) {
                if ((data & 1L << VisibilityEncoding.bit(from, to)) != 0L) {
                    sb.append('x');
                    continue;
                }
                sb.append(' ');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static interface DataHolder {
        public boolean canFaceSeeFace(int var1, int var2);
    }
}

