/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.BetterMipmaps;

import lombok.Generated;
import org.embeddedt.embeddium.api.util.ColorABGR;
import org.embeddedt.embeddium.impl.texture.MipmapHelper;
import org.embeddedt.embeddium.impl.util.color.ColorSRGB;

public final class BetterMipmapsModule {
    public static void correctAlpha(String iconName, int[] nativeImage) {
        if (iconName.contains("leaves")) {
            return;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalWeight = 0.0f;
        for (int y = 0; y < nativeImage.length; ++y) {
            int color = nativeImage[y];
            int alpha = ColorABGR.unpackAlpha(color);
            if (alpha <= 0 || alpha >= 255) continue;
            float weight = alpha;
            r += ColorSRGB.srgbToLinear(ColorABGR.unpackRed(color)) * weight;
            g += ColorSRGB.srgbToLinear(ColorABGR.unpackGreen(color)) * weight;
            b += ColorSRGB.srgbToLinear(ColorABGR.unpackBlue(color)) * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0f) {
            return;
        }
        int avgColor = ColorSRGB.linearToSrgb(r /= totalWeight, g /= totalWeight, b /= totalWeight, 0);
        for (int y = 0; y < nativeImage.length; ++y) {
            int color = nativeImage[y];
            int alpha = ColorABGR.unpackAlpha(color);
            if (alpha != 0) continue;
            nativeImage[y] = avgColor;
        }
    }

    public static int weightedAverageColor(int v1, int v2, int v3, int v4) {
        int v1_v2 = MipmapHelper.weightedAverageColor(v1, v2);
        int v3_v4 = MipmapHelper.weightedAverageColor(v3, v4);
        return MipmapHelper.weightedAverageColor(v1_v2, v3_v4);
    }

    @Generated
    private BetterMipmapsModule() {
    }
}

