/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.lang.reflect.Field;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTracker;
import org.embeddedt.embeddium.impl.util.PositionUtil;

public class SafeChunkTracker
extends ChunkTracker {
    private static final Field chunkStatus;
    private static final Field chunkReady;
    private static final Field unloadQueue;
    private static final Field loadQueue;
    private final LongOpenHashSet chunkReadyForced = new LongOpenHashSet();

    private Long2IntOpenHashMap chunkStatus() {
        return (Long2IntOpenHashMap)chunkStatus.get(this);
    }

    private LongOpenHashSet chunkReady() {
        return (LongOpenHashSet)chunkReady.get(this);
    }

    private LongSet unloadQueue() {
        return (LongSet)unloadQueue.get(this);
    }

    private LongSet loadQueue() {
        return (LongSet)loadQueue.get(this);
    }

    @Override
    public void onChunkStatusAdded(int x, int z, int flags) {
        int cur;
        long key = PositionUtil.packChunk(x, z);
        int prev = this.chunkStatus().get(key);
        if (prev == (cur = prev | flags)) {
            return;
        }
        this.chunkStatus().put(key, cur);
        this.updateNeighbors(x, z);
    }

    @Override
    public void onChunkStatusRemoved(int x, int z, int flags) {
        int cur;
        long key = PositionUtil.packChunk(x, z);
        int prev = this.chunkStatus().get(key);
        if (prev == (cur = prev & ~flags)) {
            return;
        }
        if (cur == this.chunkStatus().defaultReturnValue()) {
            this.chunkStatus().remove(key);
        } else {
            this.chunkStatus().put(key, cur);
        }
        this.updateNeighbors(x, z);
    }

    private void updateNeighbors(int x, int z) {
        for (int ox = -1; ox <= 1; ++ox) {
            for (int oz = -1; oz <= 1; ++oz) {
                this.updateMerged(ox + x, oz + z);
            }
        }
    }

    private void updateMerged(int x, int z) {
        int selfFlag;
        long key = PositionUtil.packChunk(x, z);
        int flags = selfFlag = this.chunkStatus().get(key);
        for (int ox = -1; ox <= 1; ++ox) {
            for (int oz = -1; oz <= 1; ++oz) {
                flags &= this.chunkStatus().get(PositionUtil.packChunk(ox + x, oz + z));
            }
        }
        if (flags == 3) {
            if ((this.chunkReadyForced.add(key) || this.chunkReady().add(key)) && !this.unloadQueue().remove(key)) {
                this.loadQueue().add(key);
            }
        } else if (selfFlag == 3) {
            if ((this.chunkReadyForced.add(key) || this.chunkReady().remove(key)) && !this.unloadQueue().remove(key)) {
                this.loadQueue().add(key);
            }
        } else if ((this.chunkReadyForced.remove(key) || this.chunkReady().remove(key)) && !this.loadQueue().remove(key)) {
            this.unloadQueue().add(key);
        }
    }

    @Override
    public LongCollection getReadyChunks() {
        return LongSets.unmodifiable((LongSet)this.chunkReadyForced);
    }

    static {
        try {
            Class<ChunkTracker> klass = ChunkTracker.class;
            chunkStatus = klass.getDeclaredField("chunkStatus");
            chunkStatus.setAccessible(true);
            chunkReady = klass.getDeclaredField("chunkReady");
            chunkReady.setAccessible(true);
            unloadQueue = klass.getDeclaredField("unloadQueue");
            unloadQueue.setAccessible(true);
            loadQueue = klass.getDeclaredField("loadQueue");
            loadQueue.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

