/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.vertex;

import com.ventooth.beddium.modules.TerrainRendering.vertex.CompatibleChunkVertex;
import java.util.Map;
import lombok.Generated;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeFormat;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.lwjgl.system.MemoryUtil;

final class RPLEChunkVertex
implements CompatibleChunkVertex {
    static final CompatibleChunkVertex INSTANCE = new RPLEChunkVertex();
    private static final int ATTRIB_STRIDE = 36;
    private static final GlVertexFormat VERTEX_FORMAT = GlVertexFormat.builder(36).addElement("a_PosId", 0, GlVertexAttributeFormat.FLOAT, 3, false, false).addElement("a_Color", 12, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true, false).addElement("a_TexCoord", 16, GlVertexAttributeFormat.FLOAT, 2, false, false).addElement("a_LightCoord_r", 24, GlVertexAttributeFormat.UNSIGNED_INT, 1, false, true).addElement("a_LightCoord_g", 28, GlVertexAttributeFormat.UNSIGNED_INT, 1, false, true).addElement("a_LightCoord_b", 32, GlVertexAttributeFormat.UNSIGNED_INT, 1, false, true).build();
    private static final int RAWBUF_STRIDE = 10;

    private static void decode(Vertex vertex, int[] rawBuffer, int ptr) {
        vertex.x = Float.intBitsToFloat(rawBuffer[ptr + 0]);
        vertex.y = Float.intBitsToFloat(rawBuffer[ptr + 1]);
        vertex.z = Float.intBitsToFloat(rawBuffer[ptr + 2]);
        vertex.u = Float.intBitsToFloat(rawBuffer[ptr + 3]);
        vertex.v = Float.intBitsToFloat(rawBuffer[ptr + 4]);
        vertex.color = rawBuffer[ptr + 5];
        vertex.vanillaNormal = rawBuffer[ptr + 6];
        vertex.rple$lightR = rawBuffer[ptr + 7];
        vertex.rple$lightG = rawBuffer[ptr + 8];
        vertex.rple$lightB = rawBuffer[ptr + 9];
    }

    private static void encode(long ptr, Material material, Vertex vertex, int sectionIndex) {
        MemoryUtil.memPutFloat((long)(ptr + 0L), (float)vertex.x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)vertex.y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)vertex.z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)vertex.color);
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)CompatibleChunkVertex.encodeTexture(vertex.u));
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)CompatibleChunkVertex.encodeTexture(vertex.v));
        MemoryUtil.memPutInt((long)(ptr + 24L), (int)(CompatibleChunkVertex.encodeDrawParameters(material, sectionIndex) << 0 | CompatibleChunkVertex.encodeLightRPLE(vertex.rple$lightR) << 16));
        MemoryUtil.memPutInt((long)(ptr + 28L), (int)(CompatibleChunkVertex.encodeLightRPLE(vertex.rple$lightG) << 16));
        MemoryUtil.memPutInt((long)(ptr + 32L), (int)(CompatibleChunkVertex.encodeLightRPLE(vertex.rple$lightB) << 16));
    }

    @Override
    public int attribStride() {
        return 36;
    }

    @Override
    public int rawBufStride() {
        return 10;
    }

    @Override
    public GlVertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder createEncoder() {
        return (ptr, material, baseVertex, sectionIndex) -> {
            if (baseVertex instanceof Vertex) {
                Vertex vertex = (Vertex)baseVertex;
                RPLEChunkVertex.encode(ptr, material, vertex, sectionIndex);
                return ptr + 36L;
            }
            if (baseVertex == null) {
                throw new NullPointerException("Cannot encode null vertex");
            }
            String expected = Vertex.class.getName();
            String actual = baseVertex.getClass().getName();
            throw new IllegalArgumentException("Wrong vertex type, expected: %s got: %s".formatted(expected, actual));
        };
    }

    @Override
    public Map<String, String> getDefines() {
        Map<String, String> map = CompatibleChunkVertex.super.getDefines();
        map.put("RPLE", "");
        return map;
    }

    @Override
    public CompatibleChunkVertex.Vertex[] uninitializedQuad() {
        return new Vertex[]{new Vertex(), new Vertex(), new Vertex(), new Vertex()};
    }

    @Generated
    private RPLEChunkVertex() {
    }

    private static class Vertex
    extends CompatibleChunkVertex.Vertex {
        public int rple$lightR;
        public int rple$lightG;
        public int rple$lightB;

        private Vertex() {
        }

        @Override
        public void copyRawBuffer(int[] rawBuffer, int ptr) {
            RPLEChunkVertex.decode(this, rawBuffer, ptr);
        }
    }
}

