/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.common.util;

import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    private static final TimeUnit[] UNITS = TimeUnit.values();

    private static TimeUnit chooseUnit(long duration, TimeUnit unit) {
        for (int i = UNITS.length - 1; i > unit.ordinal(); --i) {
            if (UNITS[i].convert(duration, unit) <= 0L) continue;
            return UNITS[i];
        }
        return unit;
    }

    private static String abbreviateTime(TimeUnit unit) {
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.NANOSECONDS -> "ns";
            case TimeUnit.MICROSECONDS -> "us";
            case TimeUnit.MILLISECONDS -> "ms";
            case TimeUnit.SECONDS -> "s";
            case TimeUnit.MINUTES -> "min";
            case TimeUnit.HOURS -> "h";
            case TimeUnit.DAYS -> "d";
        };
    }

    public static String stringifyTime(long duration, TimeUnit unit) {
        return TimeUtil.stringifyTime(duration, unit, TimeUtil.chooseUnit(duration, unit));
    }

    public static String stringifyTime(long duration, TimeUnit unit, TimeUnit displayUnit) {
        double displayDuration = (double)duration / (double)unit.convert(1L, displayUnit);
        return String.format(Locale.ROOT, "%.4g %s", displayDuration, TimeUtil.abbreviateTime(displayUnit));
    }
}

