/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.shader;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShaderConstants {
    public static final ShaderConstants EMPTY = ShaderConstants.builder().build();
    private final List<String> defines;

    private ShaderConstants(List<String> defines) {
        this.defines = defines;
    }

    public List<String> getDefineStrings() {
        return this.defines;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String EMPTY_VALUE = "";
        private final HashMap<String, String> constants = new HashMap();

        private Builder() {
        }

        public Builder add(String name) {
            return this.add(name, EMPTY_VALUE);
        }

        public Builder add(String name, String value) {
            String prev = this.constants.get(name);
            if (prev != null) {
                throw new IllegalArgumentException("Constant " + name + " is already defined with value " + prev);
            }
            this.constants.put(name, value);
            return this;
        }

        public ShaderConstants build() {
            ArrayList<CallSite> defines = new ArrayList<CallSite>(this.constants.size());
            for (Map.Entry<String, String> entry : this.constants.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value.isEmpty()) {
                    defines.add((CallSite)((Object)("#define " + key)));
                    continue;
                }
                defines.add((CallSite)((Object)("#define " + key + " " + value)));
            }
            return new ShaderConstants(Collections.unmodifiableList(defines));
        }

        public Builder addAll(Collection<String> defines) {
            for (String value : defines) {
                this.add(value);
            }
            return this;
        }

        public Builder addAll(Map<String, String> defines) {
            defines.forEach(this::add);
            return this;
        }
    }
}

