/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.executor;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkTaskOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobResult;
import org.jetbrains.annotations.NotNull;

public class ChunkJobMetricsTracker {
    public static final long OBSERVATION_COUNT_TIME = TimeUnit.SECONDS.toNanos(1L);
    private final Reference2ReferenceMap<Class<? extends ChunkTaskOutput>, MetricsData> metricsByTask = new Reference2ReferenceArrayMap(2);
    private long lastTimeIntervalFlip = System.nanoTime();

    public void tick() {
        long time = System.nanoTime();
        if (time - this.lastTimeIntervalFlip >= OBSERVATION_COUNT_TIME) {
            for (MetricsData data : this.metricsByTask.values()) {
                data.observationsInLastTimeInterval = data.observationsInCurrentTimeInterval;
                data.observationsInCurrentTimeInterval = 0;
            }
            this.lastTimeIntervalFlip = time;
        }
    }

    public void collectMetrics(ChunkJobResult.Success<? extends ChunkTaskOutput> successfulResult) {
        if (successfulResult.executionTimeNanos() < 0L) {
            return;
        }
        MetricsData data = (MetricsData)this.metricsByTask.computeIfAbsent(successfulResult.output().getClass(), $ -> new MetricsData());
        data.collect(successfulResult.executionTimeNanos());
    }

    public Reference2ReferenceMap<Class<? extends ChunkTaskOutput>, MetricsData> getMetrics() {
        return Reference2ReferenceMaps.unmodifiable(this.metricsByTask);
    }

    public static class MetricsData {
        private static final int MAX_OBSERVATIONS = 10000;
        private final LongArrayList observations = new LongArrayList(10000);
        private int nextInsertPoint = 0;
        private int observationsInLastTimeInterval;
        private int observationsInCurrentTimeInterval;

        public void collect(long observation) {
            if (this.observations.size() < 10000) {
                this.observations.add(observation);
            } else {
                this.observations.set(this.nextInsertPoint++, observation);
                if (this.nextInsertPoint >= 10000) {
                    this.nextInsertPoint = 0;
                }
            }
            ++this.observationsInCurrentTimeInterval;
        }

        public int getObservationsInLastTimeInterval() {
            return this.observationsInLastTimeInterval;
        }

        public MetricStats getStats() {
            int count = this.observations.size();
            if (count == 0) {
                return new MetricStats(0L, 0L, 0L);
            }
            LongListIterator iter = this.observations.iterator();
            long sum = 0L;
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            while (iter.hasNext()) {
                long observation = (Long)iter.next();
                sum += observation;
                min = Math.min(min, observation);
                max = Math.max(max, observation);
            }
            return new MetricStats(sum / (long)count, max, min);
        }
    }

    public record MetricStats(long avg, long max, long min) {
        public String toString(LongFunction<String> observationStringifier) {
            return "avg = " + observationStringifier.apply(this.avg) + ", max = " + observationStringifier.apply(this.max) + ", min = " + observationStringifier.apply(this.min);
        }

        @Override
        @NotNull
        public String toString() {
            return this.toString(String::valueOf);
        }
    }
}

