/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.pipeline;

import java.util.List;
import org.embeddedt.embeddium.impl.model.quad.BakedQuadView;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;

public class BakedQuadGroupAnalyzer {
    public static final int USE_REORIENTING = 1;
    public static final int USE_RENDER_PASS_OPTIMIZATION = 2;
    public static final int USE_ALL_THINGS = -1;
    private int defaultRenderingFlags = 0;
    private int unassignedFaceRenderingFlags = 0;

    private static int computeLightFlagMask(BakedQuadView quad) {
        int flag = 0;
        if (quad.hasAmbientOcclusion()) {
            flag |= 1;
        }
        if (quad.hasShade()) {
            flag |= 2;
        }
        return flag;
    }

    private SpriteTransparencyLevel getQuadTransparencyLevel(BakedQuadView quad) {
        if ((quad.getFlags() & 0x20) == 0 || quad.celeritas$getSprite() == null) {
            return SpriteTransparencyLevel.TRANSLUCENT;
        }
        return SpriteTransparencyLevel.Holder.getTransparencyLevel(quad.celeritas$getSprite());
    }

    public void setDefaultRenderingFlags(int flags) {
        this.defaultRenderingFlags = flags;
        this.unassignedFaceRenderingFlags = flags;
    }

    public int getFlagsForRendering(ModelQuadFacing facing, List<? extends BakedQuadView> quads) {
        int quadRenderingFlags = facing == ModelQuadFacing.UNASSIGNED ? this.unassignedFaceRenderingFlags : this.defaultRenderingFlags;
        int quadsSize = quads.size();
        if (quadsSize >= 2) {
            int flagMask = -1;
            SpriteTransparencyLevel highestSeenLevel = SpriteTransparencyLevel.OPAQUE;
            for (int i = 0; i < quadsSize; ++i) {
                BakedQuadView quad = BakedQuadView.of(quads.get(i));
                int newFlag = BakedQuadGroupAnalyzer.computeLightFlagMask(quad);
                if (flagMask == -1) {
                    flagMask = newFlag;
                } else if (newFlag != flagMask) {
                    quadRenderingFlags &= 0xFFFFFFFE;
                }
                SpriteTransparencyLevel level = this.getQuadTransparencyLevel(quad);
                if (level.ordinal() < highestSeenLevel.ordinal()) {
                    quadRenderingFlags &= 0xFFFFFFFD;
                    continue;
                }
                highestSeenLevel = level;
            }
        }
        this.unassignedFaceRenderingFlags &= quadRenderingFlags;
        return quadRenderingFlags;
    }

    public static Material chooseOptimalMaterial(Material defaultMaterial, RenderPassConfiguration<?> renderPassConfiguration, BakedQuadView quad) {
        if (defaultMaterial == renderPassConfiguration.defaultSolidMaterial() || (quad.getFlags() & 0x20) == 0 || quad.celeritas$getSprite() == null) {
            return defaultMaterial;
        }
        SpriteTransparencyLevel level = SpriteTransparencyLevel.Holder.getTransparencyLevel(quad.celeritas$getSprite());
        if (level == SpriteTransparencyLevel.OPAQUE) {
            return renderPassConfiguration.defaultSolidMaterial();
        }
        if (level == SpriteTransparencyLevel.TRANSPARENT && defaultMaterial == renderPassConfiguration.defaultTranslucentMaterial()) {
            return renderPassConfiguration.defaultCutoutMippedMaterial();
        }
        return defaultMaterial;
    }
}

