/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.lists;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderListIterable;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.util.iterator.ReversibleObjectArrayIterator;

public class SortedRenderLists
implements ChunkRenderListIterable {
    private static final SortedRenderLists EMPTY = new SortedRenderLists((ObjectArrayList<ChunkRenderList>)new ObjectArrayList());
    private final ObjectArrayList<ChunkRenderList> lists;
    private final ReferenceOpenHashSet<TerrainRenderPass> passes;

    SortedRenderLists(ObjectArrayList<ChunkRenderList> lists) {
        this.lists = lists;
        this.passes = SortedRenderLists.getAllPassesInLists(lists);
    }

    private static ReferenceOpenHashSet<TerrainRenderPass> getAllPassesInLists(ObjectArrayList<ChunkRenderList> lists) {
        ReferenceOpenHashSet usedPasses = new ReferenceOpenHashSet();
        for (ChunkRenderList list : lists) {
            usedPasses.addAll(list.getRegion().getPasses());
        }
        return usedPasses;
    }

    public ReversibleObjectArrayIterator<ChunkRenderList> iterator(boolean reverse) {
        return new ReversibleObjectArrayIterator<ChunkRenderList>(this.lists, reverse);
    }

    @Override
    public boolean hasPass(TerrainRenderPass pass) {
        return this.passes.contains((Object)pass);
    }

    public Set<TerrainRenderPass> getPasses() {
        return this.passes;
    }

    public static SortedRenderLists empty() {
        return EMPTY;
    }
}

