/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.terrain;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.embeddedt.embeddium.impl.common.util.NativeBuffer;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderMatrices;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.RenderSectionManager;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTracker;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTrackerHolder;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.viewport.CameraTransform;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.util.PositionUtil;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleWorldRenderer<WORLD, SECTIONMANAGER extends RenderSectionManager, LAYER, BLOCKENTITY, BLOCKENTITY_RENDER_CONTEXT> {
    protected WORLD world;
    protected int renderDistance;
    protected CameraState lastCameraState;
    protected Viewport currentViewport;
    protected SECTIONMANAGER renderSectionManager;
    public static final double MAX_ENTITY_CHECK_VOLUME = 61440.0;

    public void setWorld(WORLD world) {
        if (this.world == world) {
            return;
        }
        if (this.world != null) {
            this.unloadWorld();
        }
        if (world != null) {
            this.loadWorld(world);
        }
    }

    protected void loadWorld(WORLD world) {
        this.world = world;
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    protected void unloadWorld() {
        if (this.renderSectionManager != null) {
            ((RenderSectionManager)this.renderSectionManager).destroy();
            this.renderSectionManager = null;
        }
        this.world = null;
    }

    public int getVisibleChunkCount() {
        return ((RenderSectionManager)this.renderSectionManager).getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.renderSectionManager != null) {
            ((RenderSectionManager)this.renderSectionManager).markGraphDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return ((RenderSectionManager)this.renderSectionManager).getBuilder().isBuildQueueEmpty();
    }

    public abstract int getEffectiveRenderDistance();

    public void setupTerrain(Viewport viewport, CameraState cameraState, @Deprecated(forRemoval=true) int frame, boolean spectator, boolean updateChunksImmediately) {
        boolean dirty;
        boolean isShadowPass;
        NativeBuffer.reclaim(false);
        if (this.renderSectionManager != null) {
            ((RenderSectionManager)this.renderSectionManager).finishAllGraphUpdates();
        }
        if (!(isShadowPass = ((RenderSectionManager)this.renderSectionManager).isInShadowPass())) {
            this.processChunkEvents();
            ((RenderSectionManager)this.renderSectionManager).runAsyncTasks();
            if (this.getEffectiveRenderDistance() != this.renderDistance) {
                this.reload();
            }
        }
        boolean bl = dirty = this.lastCameraState == null || !this.lastCameraState.equals(cameraState);
        if (dirty) {
            ((RenderSectionManager)this.renderSectionManager).markGraphDirty();
            this.lastCameraState = cameraState;
        }
        this.currentViewport = viewport;
        ((RenderSectionManager)this.renderSectionManager).runAsyncTasks();
        ((RenderSectionManager)this.renderSectionManager).updateChunks(updateChunksImmediately);
        if (!isShadowPass) {
            ((RenderSectionManager)this.renderSectionManager).uploadChunks();
        }
        if (((RenderSectionManager)this.renderSectionManager).needsUpdate() || isShadowPass) {
            ((RenderSectionManager)this.renderSectionManager).update(viewport, frame, spectator);
        }
        if (updateChunksImmediately) {
            ((RenderSectionManager)this.renderSectionManager).uploadChunks();
        }
        ((RenderSectionManager)this.renderSectionManager).tickVisibleRenders();
    }

    private void processChunkEvents() {
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        tracker.forEachEvent((arg_0, arg_1) -> this.renderSectionManager.onChunkAdded(arg_0, arg_1), (arg_0, arg_1) -> this.renderSectionManager.onChunkRemoved(arg_0, arg_1));
    }

    protected abstract ChunkRenderMatrices createChunkRenderMatrices();

    public Viewport getLastViewport() {
        return this.currentViewport;
    }

    public void drawChunkLayer(LAYER renderLayer, double x, double y, double z) {
        ChunkRenderMatrices matrices = this.createChunkRenderMatrices();
        Collection<TerrainRenderPass> passes = ((RenderSectionManager)this.renderSectionManager).getRenderPassConfiguration().vanillaRenderStages().get(renderLayer);
        if (passes != null && !passes.isEmpty()) {
            CameraTransform occlusionCamera = this.getLastViewport().getTransform();
            CameraTransform realCamera = new CameraTransform(x, y, z);
            for (TerrainRenderPass pass : passes) {
                ((RenderSectionManager)this.renderSectionManager).renderLayer(matrices, pass, occlusionCamera, realCamera);
            }
        }
    }

    public void reload() {
        if (this.world == null) {
            return;
        }
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    protected abstract SECTIONMANAGER createRenderSectionManager(CommandList var1);

    protected void initRenderer(CommandList commandList) {
        if (this.renderSectionManager != null) {
            ((RenderSectionManager)this.renderSectionManager).destroy();
            this.renderSectionManager = null;
        }
        this.renderDistance = this.getEffectiveRenderDistance();
        this.renderSectionManager = this.createRenderSectionManager(commandList);
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        ChunkTracker.forEachChunk(tracker.getReadyChunks(), (arg_0, arg_1) -> this.renderSectionManager.onChunkAdded(arg_0, arg_1));
    }

    public Iterator<BLOCKENTITY> blockEntityIterator() {
        return MinecraftBuiltRenderSectionData.generateBlockEntityIterator(((RenderSectionManager)this.renderSectionManager).getRenderLists(), ((RenderSectionManager)this.renderSectionManager).getSectionsWithGlobalEntities());
    }

    public void forEachVisibleBlockEntity(Consumer<BLOCKENTITY> consumer) {
        MinecraftBuiltRenderSectionData.forEachBlockEntity(consumer, ((RenderSectionManager)this.renderSectionManager).getRenderLists(), ((RenderSectionManager)this.renderSectionManager).getSectionsWithGlobalEntities());
    }

    protected abstract void renderBlockEntityList(List<BLOCKENTITY> var1, BLOCKENTITY_RENDER_CONTEXT var2);

    private int renderCulledBlockEntities(BLOCKENTITY_RENDER_CONTEXT renderContext) {
        int count = 0;
        SortedRenderLists renderLists = ((RenderSectionManager)this.renderSectionManager).getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                BuiltRenderSectionData context;
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                if (renderSection == null || !((context = renderSection.getBuiltContext()) instanceof MinecraftBuiltRenderSectionData)) continue;
                MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
                List blockEntities = mcData.culledBlockEntities;
                if (blockEntities.isEmpty()) continue;
                count += blockEntities.size();
                this.renderBlockEntityList(blockEntities, renderContext);
            }
        }
        return count;
    }

    private int renderGlobalBlockEntities(BLOCKENTITY_RENDER_CONTEXT renderContext) {
        int count = 0;
        for (RenderSection renderSection : ((RenderSectionManager)this.renderSectionManager).getSectionsWithGlobalEntities()) {
            BuiltRenderSectionData context = renderSection.getBuiltContext();
            if (!(context instanceof MinecraftBuiltRenderSectionData)) continue;
            MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
            List blockEntities = mcData.globalBlockEntities;
            if (blockEntities.isEmpty()) continue;
            count += blockEntities.size();
            this.renderBlockEntityList(blockEntities, renderContext);
        }
        return count;
    }

    public int renderBlockEntities(BLOCKENTITY_RENDER_CONTEXT renderContext) {
        int count = 0;
        count += this.renderCulledBlockEntities(renderContext);
        return count += this.renderGlobalBlockEntities(renderContext);
    }

    public abstract int getMinimumBuildHeight();

    public abstract int getMaximumBuildHeight();

    public boolean isPointVisible(double x, double y, double z) {
        if (y < (double)this.getMinimumBuildHeight() + 0.5 || y > (double)this.getMaximumBuildHeight() - 0.5) {
            return true;
        }
        return ((RenderSectionManager)this.renderSectionManager).isSectionVisible(PositionUtil.posToSectionCoord(x), PositionUtil.posToSectionCoord(y), PositionUtil.posToSectionCoord(z));
    }

    public boolean isBoxVisible(double x1, double y1, double z1, double x2, double y2, double z2) {
        if (y2 < (double)this.getMinimumBuildHeight() + 0.5 || y1 > (double)this.getMaximumBuildHeight() - 0.5) {
            return true;
        }
        double entityVolume = (x2 - x1) * (y2 - y1) * (z2 - z1);
        if (entityVolume > 61440.0) {
            return true;
        }
        int minX = PositionUtil.posToSectionCoord(x1 - 0.5);
        int minY = PositionUtil.posToSectionCoord(y1 - 0.5);
        int minZ = PositionUtil.posToSectionCoord(z1 - 0.5);
        int maxX = PositionUtil.posToSectionCoord(x2 + 0.5);
        int maxY = PositionUtil.posToSectionCoord(y2 + 0.5);
        int maxZ = PositionUtil.posToSectionCoord(z2 + 0.5);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!((RenderSectionManager)this.renderSectionManager).isSectionVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getChunksDebugString() {
        return String.format("C: %d/%d D: %d %s", ((RenderSectionManager)this.renderSectionManager).getVisibleChunkCount(), ((RenderSectionManager)this.renderSectionManager).getTotalSections(), this.renderDistance, ((RenderSectionManager)this.renderSectionManager).getTickerDebugString());
    }

    public RenderPassConfiguration<?> getRenderPassConfiguration() {
        return ((RenderSectionManager)this.renderSectionManager).getRenderPassConfiguration();
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.scheduleRebuildForChunks(minX >> 4, minY >> 4, minZ >> 4, maxX >> 4, maxY >> 4, maxZ >> 4, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        ((RenderSectionManager)this.renderSectionManager).scheduleRebuild(x, y, z, important);
    }

    public Collection<String> getDebugStrings() {
        return ((RenderSectionManager)this.renderSectionManager).getDebugStrings();
    }

    public boolean isSectionReady(int x, int y, int z) {
        return ((RenderSectionManager)this.renderSectionManager).isSectionBuilt(x, y, z);
    }

    public SECTIONMANAGER getRenderSectionManager() {
        return this.renderSectionManager;
    }

    public record CameraState(double x, double y, double z, double pitch, double yaw, float fogDistance) {
    }

    public static interface Provider<T extends SimpleWorldRenderer<?, ?, ?, ?, ?>> {
        public T celeritas$getWorldRenderer();

        @Nullable
        public static <T extends SimpleWorldRenderer<?, ?, ?, ?, ?>> T getWorldRendererNullable(Object o) {
            return ((Provider)o).celeritas$getWorldRenderer();
        }

        @NotNull
        public static <T extends SimpleWorldRenderer<?, ?, ?, ?, ?>> T getWorldRenderer(Object o) {
            T result = Provider.getWorldRendererNullable(o);
            if (result == null) {
                throw new IllegalStateException("No renderer attached to active world");
            }
            return result;
        }
    }
}

