/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.config;

import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.config.ConfigurationManager;
import com.ventooth.beddium.config.ModuleConfig;
import com.ventooth.beddium.config.TerrainRenderingConfig;
import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

@NestMembers(value={CfgCategory.class})
public final class Configs {
    public static void poke() {
    }

    private static void init() {
        ConfigurationManager.initialize((Class[])Configs.cfgClasses());
    }

    static Class<?>[] cfgClasses() {
        List<CfgCategory> categories = Configs.cfgCategories(true);
        ArrayList types = new ArrayList();
        for (CfgCategory category : categories) {
            types.add(category.type());
        }
        return types.toArray(new Class[0]);
    }

    static List<IConfigElement> cfgElements() throws ConfigException {
        List<CfgCategory> categories = Configs.cfgCategories(false);
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        for (CfgCategory category : categories) {
            elements.add(category.asElement());
        }
        return elements;
    }

    static List<CfgCategory> cfgCategories(boolean init) {
        ArrayList<CfgCategory> categories = new ArrayList<CfgCategory>();
        categories.add(new CfgCategory("00_modules", "config.beddium.modules.Modules", ModuleConfig.class));
        if (init || ModuleConfig.TerrainRendering) {
            categories.add(new CfgCategory("01_terrain", "config.beddium.modules.TerrainRendering", TerrainRenderingConfig.class));
        }
        return categories;
    }

    @Generated
    private Configs() {
    }

    static {
        Configs.init();
    }

    @RecordComponents(value={@RecordComponents.Value(name="name", type=String.class), @RecordComponents.Value(name="lang", type=String.class), @RecordComponents.Value(name="type", type=Class.class)})
    @NestHost(value=Configs.class)
    static final class CfgCategory
    extends J_L_Record {
        private final String name;
        private final String lang;
        private final Class<?> type;

        CfgCategory(String name, String lang, Class<?> type) {
            this.name = name;
            this.lang = lang;
            this.type = type;
        }

        IConfigElement asElement() throws ConfigException {
            List innerElements = ConfigurationManager.getConfigElementsMulti((Class[])new Class[]{this.type});
            return new DummyConfigElement.DummyCategoryElement(this.name, this.lang, innerElements);
        }

        public final String toString() {
            return CfgCategory.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return CfgCategory.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return CfgCategory.jvmdowngrader$equals$equals(this, o);
        }

        public String name() {
            return this.name;
        }

        public String lang() {
            return this.lang;
        }

        public Class<?> type() {
            return this.type;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(CfgCategory cfgCategory) {
            CfgCategory cfgCategory2 = cfgCategory;
            return "Configs$CfgCategory[" + "name=" + cfgCategory.name + ", " + "lang=" + cfgCategory.lang + ", " + "type=" + cfgCategory.type + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(CfgCategory cfgCategory) {
            Object[] objectArray = new Object[]{cfgCategory.name, cfgCategory.lang, cfgCategory.type};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(CfgCategory cfgCategory, Object object) {
            if (cfgCategory == object) {
                return true;
            }
            if (object != null && object instanceof CfgCategory) {
                CfgCategory cfgCategory2 = (CfgCategory)((Object)object);
                if (Objects.equals(cfgCategory.name, cfgCategory2.name) && Objects.equals(cfgCategory.lang, cfgCategory2.lang) && Objects.equals(cfgCategory.type, cfgCategory2.type)) {
                    return true;
                }
            }
            return false;
        }
    }
}

