/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.config;

import com.falsepattern.lib.config.Config;
import com.ventooth.beddium.config.Configs;
import lombok.Generated;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@Config.Comment(value={"Celeritas based terrain rendering"})
@Config(modid="beddium", category="01_terrain")
@Config.LangKey
@NestMembers(value={DrawModeEnum.class})
public final class TerrainRenderingConfig {
    @Config.Name(value="MEGAChunks")
    @Config.Comment(value={"Larger chunk renderers. One minecraft 16x256x16 chunk is 16 subchunks", "0 - 1x1x1 - 1 subchunk per renderer (disabled)", "1 - 2x2x2 - 8 subchunks per renderer", "2 - 4x4x4 - 64 subchunks per renderer", "3 - 8x8x8 - 512 subchunks per renderer (implementation limit)"})
    @Config.LangKey(value="config.beddium.terrainrendering.MEGAChunks")
    @Config.RequiresMcRestart
    @Config.DefaultInt(value=0)
    @Config.RangeInt(min=0, max=3)
    public static int MEGAChunks;
    @Config.Name(value="ChunkDrawMode")
    @Config.Comment(value={"Changes the way chunks at the world edge are rendered.", "Vanilla: Renders \"chunk cliffs\" at the world edge. Slightly slower,", "         but fixes issues such as invisible chunks in minigame servers,", "         or reduced render distance.", "Fast: Only renders chunks if all of the neighboring chunks are loaded.", "      A bit faster than safe, but on some servers this might cause missing", "      chunks at map edges,", "      and it reduces visual render distance by 1 (the chunks are still present)."})
    @Config.LangKey(value="config.beddium.terrainrendering.ChunkDrawMode")
    @Config.RequiresWorldRestart
    @Config.DefaultEnum(value="Vanilla")
    public static DrawModeEnum ChunkDrawMode;
    @Config.Name(value="FastChunkDrawModeFogBias")
    @Config.Comment(value={"Adds a bias (in blocks) to the fog distance when using Fast Chunk Edge Mode.", "The default value is set to hide all pop in, but can be adjusted to taste."})
    @Config.LangKey(value="config.beddium.terrainrendering.FastChunkDrawModeFogBias")
    @Config.DefaultDouble(value=-16.0)
    @Config.RangeDouble(min=-16.0, max=0.0)
    public static double FastChunkDrawModeFogBias;
    @Config.Name(value="UseMultiDrawIndirect")
    @Config.Comment(value={"Controls if chunks should be drawn using MultiDrawIndirect.", "This option is a trade off between CPU and GPU overhead when rendering chunks.", "It is best left disabled in most cases, particularly on Intel iGPUs.", "Can improve performance on render distances beyond 16 if you are CPU limited."})
    @Config.LangKey(value="config.beddium.terrainrendering.UseMultiDrawIndirect")
    @Config.RequiresWorldRestart
    @Config.DefaultBoolean(value=false)
    public static boolean UseMultiDrawIndirect;
    @Config.Name(value="FastFog")
    @Config.Comment(value={"Uses a method for fog which improves performance significantly.", "Turn this off if fog looks really broken in some dimensions, but keep it enabled if possible."})
    @Config.LangKey(value="config.beddium.terrainrendering.FastFog")
    @Config.DefaultBoolean(value=true)
    public static boolean FastFog;
    @Config.Name(value="FastFogAsm")
    @Config.Comment(value={"If extra ASM hooks should be used to help track fog state."})
    @Config.LangKey(value="config.beddium.terrainrendering.FastFogAsm")
    @Config.RequiresMcRestart
    @Config.DefaultBoolean(value=true)
    public static boolean FastFogAsm;
    @Config.Name(value="FastFogAsmExclusions")
    @Config.Comment(value={"List of classes which are excluded by the ASM hooks which are excluded from fog tracking."})
    @Config.LangKey(value="config.beddium.terrainrendering.FastFogAsmExclusions")
    @Config.RequiresMcRestart
    @Config.DefaultStringList(value={"net.minecraft.*", "net.minecraftforge.*", "cpw.mods.fml.*"})
    public static String[] FastFogAsmExclusions;
    @Config.Name(value="NetherliciousCompat")
    @Config.Comment(value={"Fixes compatibility with Netherlicious.", "Without this, you may see intense flickering in the Nether."})
    @Config.LangKey(value="config.beddium.terrainrendering.NetherliciousCompat")
    @Config.RequiresMcRestart
    @Config.DefaultBoolean(value=true)
    public static boolean NetherliciousCompat;
    @Config.Name(value="AlwaysTranslucentSprites")
    @Config.Comment(value={"List of sprites which should always be treated as translucent.", "Beddium includes a feature which can automatically downgrade opaque sprites,", "incorrectly rendered on the opaque pass. Textures added to this list will", "always be considered translucent.", "", "Requires ResourcePack reload (F3+T)"})
    @Config.LangKey(value="config.beddium.terrainrendering.AlwaysTranslucentSprites")
    @Config.DefaultStringList(value={"jewelrycraft2:blockCrystal"})
    public static String[] AlwaysTranslucentSprites;

    @Generated
    private TerrainRenderingConfig() {
    }

    static {
        Configs.poke();
    }

    @NestHost(value=TerrainRenderingConfig.class)
    public static enum DrawModeEnum {
        Vanilla,
        Fast;

    }
}

