/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.vertex;

import com.ventooth.beddium.modules.TerrainRendering.vertex.CompatibleChunkVertex;
import lombok.Generated;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeFormat;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryUtil;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;

@NestMembers(value={Vertex.class})
final class DefaultChunkVertex
implements CompatibleChunkVertex {
    static final CompatibleChunkVertex INSTANCE = new DefaultChunkVertex();
    private static final int ATTRIB_STRIDE = 28;
    private static final GlVertexFormat VERTEX_FORMAT = GlVertexFormat.builder(28).addElement("a_PosId", 0, GlVertexAttributeFormat.FLOAT, 3, false, false).addElement("a_Color", 12, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true, false).addElement("a_TexCoord", 16, GlVertexAttributeFormat.FLOAT, 2, false, false).addElement("a_LightCoord", 24, GlVertexAttributeFormat.UNSIGNED_INT, 1, false, true).build();
    private static final int RAWBUF_STRIDE = 8;

    private static void decode(Vertex vertex, int[] rawBuffer, int ptr) {
        vertex.x = Float.intBitsToFloat(rawBuffer[ptr + 0]);
        vertex.y = Float.intBitsToFloat(rawBuffer[ptr + 1]);
        vertex.z = Float.intBitsToFloat(rawBuffer[ptr + 2]);
        vertex.u = Float.intBitsToFloat(rawBuffer[ptr + 3]);
        vertex.v = Float.intBitsToFloat(rawBuffer[ptr + 4]);
        vertex.color = rawBuffer[ptr + 5];
        vertex.vanillaNormal = rawBuffer[ptr + 6];
        vertex.light = rawBuffer[ptr + 7];
    }

    private static void encode(long ptr, Material material, Vertex vertex, int sectionIndex) {
        MemoryUtil.memPutFloat(ptr + 0L, vertex.x);
        MemoryUtil.memPutFloat(ptr + 4L, vertex.y);
        MemoryUtil.memPutFloat(ptr + 8L, vertex.z);
        MemoryUtil.memPutInt(ptr + 12L, vertex.color);
        MemoryUtil.memPutFloat(ptr + 16L, CompatibleChunkVertex.encodeTexture(vertex.u));
        MemoryUtil.memPutFloat(ptr + 20L, CompatibleChunkVertex.encodeTexture(vertex.v));
        MemoryUtil.memPutInt(ptr + 24L, CompatibleChunkVertex.encodeDrawParameters(material, sectionIndex) << 0 | CompatibleChunkVertex.encodeLight(vertex.light) << 16);
    }

    @Override
    public int attribStride() {
        return 28;
    }

    @Override
    public int rawBufStride() {
        return 8;
    }

    @Override
    public GlVertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder createEncoder() {
        return (ptr, material, baseVertex, sectionIndex) -> {
            if (baseVertex instanceof Vertex) {
                Vertex vertex = (Vertex)baseVertex;
                DefaultChunkVertex.encode(ptr, material, vertex, sectionIndex);
                return ptr + 28L;
            }
            if (baseVertex == null) {
                throw new NullPointerException("Cannot encode null vertex");
            }
            String expected = Vertex.class.getName();
            String actual = baseVertex.getClass().getName();
            throw new IllegalArgumentException(J_L_String.formatted((String)"Wrong vertex type, expected: %s got: %s", (Object[])new Object[]{expected, actual}));
        };
    }

    @Override
    public CompatibleChunkVertex.Vertex[] uninitializedQuad() {
        return new Vertex[]{new Vertex(), new Vertex(), new Vertex(), new Vertex()};
    }

    @Generated
    private DefaultChunkVertex() {
    }

    @NestHost(value=DefaultChunkVertex.class)
    private static class Vertex
    extends CompatibleChunkVertex.Vertex {
        Vertex() {
        }

        @Override
        public void copyRawBuffer(int[] rawBuffer, int ptr) {
            DefaultChunkVertex.decode(this, rawBuffer, ptr);
        }
    }
}

