/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.vertex;

import com.ventooth.beddium.modules.MEGAChunks.MegaChunkMetadata;
import com.ventooth.beddium.modules.TerrainRendering.vertex.CompatibleChunkVertex;
import lombok.Generated;
import org.embeddedt.embeddium.impl.gl.array.GlVertexArray;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeBinding;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeFormat;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.tessellation.TessellationBinding;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryUtil;
import org.embeddedt.embeddium.impl.render.chunk.LocalSectionIndex;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;

@NestMembers(value={Tessellation.class, Vertex.class})
final class SwanSongChunkVertex
implements CompatibleChunkVertex {
    static final CompatibleChunkVertex INSTANCE = new SwanSongChunkVertex();
    private static final int ATTRIB_STRIDE = 80;
    private static final GlVertexFormat VERTEX_FORMAT = GlVertexFormat.builder(80).addElement("POS", 0, GlVertexAttributeFormat.FLOAT, 3, false, false).addElement("TEXTURE", 12, GlVertexAttributeFormat.FLOAT, 2, true, false).addElement("COLOR", 20, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, false, false).addElement("BRIGHTNESS", 24, GlVertexAttributeFormat.SHORT, 2, false, false).addElement("ENTITY_DATA", 28, GlVertexAttributeFormat.SHORT, 3, false, false).addElement("NORMAL", 36, GlVertexAttributeFormat.FLOAT, 3, false, false).addElement("TANGENT", 48, GlVertexAttributeFormat.FLOAT, 4, false, false).addElement("MIDTEXTURE", 64, GlVertexAttributeFormat.FLOAT, 2, false, false).addElement("EDGETEXURE", 72, GlVertexAttributeFormat.FLOAT, 2, false, false).build();
    private static final int RAWBUF_STRIDE = 20;

    private static void decode(Vertex vertex, int[] rawBuffer, int ptr) {
        vertex.x = Float.intBitsToFloat(rawBuffer[ptr + 0]);
        vertex.y = Float.intBitsToFloat(rawBuffer[ptr + 1]);
        vertex.z = Float.intBitsToFloat(rawBuffer[ptr + 2]);
        vertex.u = Float.intBitsToFloat(rawBuffer[ptr + 3]);
        vertex.v = Float.intBitsToFloat(rawBuffer[ptr + 4]);
        vertex.color = rawBuffer[ptr + 5];
        vertex.light = rawBuffer[ptr + 6];
        vertex.entityData = rawBuffer[ptr + 7];
        vertex.entityData2 = rawBuffer[ptr + 8];
        vertex.normalX = Float.intBitsToFloat(rawBuffer[ptr + 9]);
        vertex.normalY = Float.intBitsToFloat(rawBuffer[ptr + 10]);
        vertex.normalZ = Float.intBitsToFloat(rawBuffer[ptr + 11]);
        vertex.tangentX = Float.intBitsToFloat(rawBuffer[ptr + 12]);
        vertex.tangentY = Float.intBitsToFloat(rawBuffer[ptr + 13]);
        vertex.tangentZ = Float.intBitsToFloat(rawBuffer[ptr + 14]);
        vertex.tangentW = Float.intBitsToFloat(rawBuffer[ptr + 15]);
        vertex.midTextureU = Float.intBitsToFloat(rawBuffer[ptr + 16]);
        vertex.midTextureV = Float.intBitsToFloat(rawBuffer[ptr + 17]);
        vertex.edgeTextureU = Float.intBitsToFloat(rawBuffer[ptr + 18]);
        vertex.edgeTextureV = Float.intBitsToFloat(rawBuffer[ptr + 19]);
    }

    private static void encode(long ptr, Material material, Vertex vertex, int sectionIndex) {
        MemoryUtil.memPutFloat(ptr + 0L, vertex.x + (float)LocalSectionIndex.unpackX(sectionIndex) * MegaChunkMetadata.BLOCKS_PER_WR_EDGE_FLOAT);
        MemoryUtil.memPutFloat(ptr + 4L, vertex.y + (float)LocalSectionIndex.unpackY(sectionIndex) * MegaChunkMetadata.BLOCKS_PER_WR_EDGE_FLOAT);
        MemoryUtil.memPutFloat(ptr + 8L, vertex.z + (float)LocalSectionIndex.unpackZ(sectionIndex) * MegaChunkMetadata.BLOCKS_PER_WR_EDGE_FLOAT);
        MemoryUtil.memPutFloat(ptr + 12L, vertex.u);
        MemoryUtil.memPutFloat(ptr + 16L, vertex.v);
        MemoryUtil.memPutInt(ptr + 20L, vertex.color);
        MemoryUtil.memPutInt(ptr + 24L, vertex.light);
        MemoryUtil.memPutInt(ptr + 28L, vertex.entityData);
        MemoryUtil.memPutInt(ptr + 32L, vertex.entityData2);
        MemoryUtil.memPutFloat(ptr + 36L, vertex.normalX);
        MemoryUtil.memPutFloat(ptr + 40L, vertex.normalY);
        MemoryUtil.memPutFloat(ptr + 44L, vertex.normalZ);
        MemoryUtil.memPutFloat(ptr + 48L, vertex.tangentX);
        MemoryUtil.memPutFloat(ptr + 52L, vertex.tangentY);
        MemoryUtil.memPutFloat(ptr + 56L, vertex.tangentZ);
        MemoryUtil.memPutFloat(ptr + 60L, vertex.tangentW);
        MemoryUtil.memPutFloat(ptr + 64L, vertex.midTextureU);
        MemoryUtil.memPutFloat(ptr + 68L, vertex.midTextureV);
        MemoryUtil.memPutFloat(ptr + 72L, vertex.edgeTextureU);
        MemoryUtil.memPutFloat(ptr + 76L, vertex.edgeTextureV);
    }

    private static void bindLegacyAttribute(GlVertexAttributeBinding attrib) {
        String name = attrib.getName();
        int size = attrib.getCount();
        int type = attrib.getFormat().typeId();
        int stride = attrib.getStride();
        int pointer = attrib.getPointer();
        switch (name) {
            case "POS": {
                GL11.glVertexPointer((int)size, (int)type, (int)stride, (long)pointer);
                GL11.glEnableClientState((int)32884);
                break;
            }
            case "TEXTURE": {
                GL13.glClientActiveTexture((int)33984);
                GL11.glTexCoordPointer((int)size, (int)type, (int)stride, (long)pointer);
                GL11.glEnableClientState((int)32888);
                break;
            }
            case "COLOR": {
                GL11.glColorPointer((int)size, (int)type, (int)stride, (long)pointer);
                GL11.glEnableClientState((int)32886);
                break;
            }
            case "BRIGHTNESS": {
                GL13.glClientActiveTexture((int)33985);
                GL11.glTexCoordPointer((int)size, (int)type, (int)stride, (long)pointer);
                GL11.glEnableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
                break;
            }
            case "ENTITY_DATA": {
                int entityAttrib = 10;
                GL20.glVertexAttribPointer((int)10, (int)size, (int)type, (boolean)false, (int)stride, (long)pointer);
                GL20.glEnableVertexAttribArray((int)10);
                break;
            }
            case "TANGENT": {
                int tangentAttrib = 12;
                GL20.glVertexAttribPointer((int)12, (int)size, (int)type, (boolean)false, (int)stride, (long)pointer);
                GL20.glEnableVertexAttribArray((int)12);
                break;
            }
            case "MIDTEXTURE": {
                int midTexCoordAttrib = 11;
                GL20.glVertexAttribPointer((int)11, (int)size, (int)type, (boolean)false, (int)stride, (long)pointer);
                GL20.glEnableVertexAttribArray((int)11);
                break;
            }
            case "NORMAL": {
                GL11.glNormalPointer((int)type, (int)stride, (long)pointer);
                GL11.glEnableClientState((int)32885);
                break;
            }
            case "EDGETEXURE": {
                int edgeTexCoordAttrib = 13;
                GL20.glVertexAttribPointer((int)13, (int)size, (int)type, (boolean)false, (int)stride, (long)pointer);
                GL20.glEnableVertexAttribArray((int)13);
                break;
            }
            default: {
                throw new IllegalStateException(SwanSongChunkVertex.jvmdowngrader$concat$bindLegacyAttribute$1(name));
            }
        }
    }

    @Override
    public int attribStride() {
        return 80;
    }

    @Override
    public int rawBufStride() {
        return 20;
    }

    @Override
    public GlVertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder createEncoder() {
        return (ptr, material, baseVertex, sectionIndex) -> {
            if (baseVertex instanceof Vertex) {
                Vertex vertex = (Vertex)baseVertex;
                SwanSongChunkVertex.encode(ptr, material, vertex, sectionIndex);
                return ptr + 80L;
            }
            if (baseVertex == null) {
                throw new NullPointerException("Cannot encode null vertex");
            }
            String expected = Vertex.class.getName();
            String actual = baseVertex.getClass().getName();
            throw new IllegalArgumentException(J_L_String.formatted((String)"Wrong vertex type, expected: %s got: %s", (Object[])new Object[]{expected, actual}));
        };
    }

    @Override
    public CompatibleChunkVertex.Vertex[] uninitializedQuad() {
        return new Vertex[]{new Vertex(), new Vertex(), new Vertex(), new Vertex()};
    }

    @Override
    public CompatibleChunkVertex.Tessellation getTessellation(GlVertexArray array, TessellationBinding[] bindings) {
        return new Tessellation(array, bindings);
    }

    @Generated
    private SwanSongChunkVertex() {
    }

    private static /* synthetic */ String jvmdowngrader$concat$bindLegacyAttribute$1(String string) {
        return "Unexpected value: " + string;
    }

    @NestHost(value=SwanSongChunkVertex.class)
    private static class Vertex
    extends CompatibleChunkVertex.Vertex {
        public int entityData;
        public int entityData2;
        public float normalX;
        public float normalY;
        public float normalZ;
        public float tangentX;
        public float tangentY;
        public float tangentZ;
        public float tangentW;
        public float midTextureU;
        public float midTextureV;
        public float edgeTextureU;
        public float edgeTextureV;

        Vertex() {
        }

        @Override
        public void copyRawBuffer(int[] rawBuffer, int ptr) {
            SwanSongChunkVertex.decode(this, rawBuffer, ptr);
        }
    }

    @NestHost(value=SwanSongChunkVertex.class)
    private static class Tessellation
    extends CompatibleChunkVertex.Tessellation {
        Tessellation(GlVertexArray array, TessellationBinding[] bindings) {
            super(array, bindings);
        }

        @Override
        protected void bindAttributes(CommandList commandList) {
            for (TessellationBinding binding : this.bindings) {
                commandList.bindBuffer(binding.target(), binding.buffer());
                for (GlVertexAttributeBinding attrib : binding.attributeBindings()) {
                    SwanSongChunkVertex.bindLegacyAttribute(attrib);
                }
            }
        }
    }
}

