/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.lwjgl2;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongStack;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryUtil;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_R_Cleaner;

@NestMembers(value={AddrCleaner.class})
public class MemoryStack
implements AutoCloseable {
    private static final int MAX_ALIGNMENT = 4096;
    private static final J_L_R_Cleaner CLEANER = J_L_R_Cleaner.create();
    private static final long CAPACITY = 0x400000L;
    private final LongStack offsets = new LongArrayList();
    private final long addr;
    private long baseOffset;
    private long currentOffset;
    private static final ThreadLocal<MemoryStack> threadLocalStack = ThreadLocal.withInitial(MemoryStack::new);

    private MemoryStack() {
        long addr = MemoryUtil.nmemAlignedAlloc(4096L, 0x400000L);
        CLEANER.register((Object)this, (Runnable)new AddrCleaner(addr));
        this.addr = addr;
        this.baseOffset = 0L;
        this.currentOffset = 0L;
    }

    private void align(int alignment) {
        long adjust = this.currentOffset % (long)alignment;
        if (adjust != 0L) {
            this.currentOffset += (long)alignment - adjust;
        }
    }

    public ByteBuffer mallocAligned(int size, int alignment) {
        if (alignment > 4096) {
            throw new IllegalArgumentException(MemoryStack.jvmdowngrader$concat$mallocAligned$1(alignment));
        }
        this.align(alignment);
        return this.malloc(size);
    }

    public long nmalloc(long size) {
        if (this.currentOffset + size > 0x400000L) {
            throw new IllegalStateException("MemoryStack overflow!");
        }
        long addr = this.currentOffset + this.addr;
        this.currentOffset += size;
        return addr;
    }

    public long ncalloc(long size) {
        long addr = this.nmalloc(size);
        MemoryUtil.memSet(addr, 0, size);
        return addr;
    }

    public ByteBuffer malloc(int size) {
        return MemoryUtil.memByteBuffer(this.nmalloc(size), size);
    }

    public ByteBuffer calloc(int size) {
        return MemoryUtil.memByteBuffer(this.ncalloc(size), size);
    }

    public IntBuffer mallocInt(int size) {
        this.align(4);
        return this.malloc(size * 4).asIntBuffer();
    }

    public IntBuffer callocInt(int size) {
        this.align(4);
        return this.calloc(size * 4).asIntBuffer();
    }

    public FloatBuffer callocFloat(int size) {
        this.align(4);
        return this.calloc(size * 4).asFloatBuffer();
    }

    public static MemoryStack getCurrentStack() {
        return threadLocalStack.get();
    }

    public MemoryStack push() {
        this.offsets.push(this.baseOffset);
        this.baseOffset = this.currentOffset;
        return this;
    }

    public void pop() {
        if (this.offsets.isEmpty()) {
            throw new RuntimeException("Tried to pop empty memory stack!");
        }
        this.currentOffset = this.baseOffset;
        this.baseOffset = (Long)this.offsets.pop();
    }

    public static MemoryStack stackPush() {
        MemoryStack stack = threadLocalStack.get();
        return stack.push();
    }

    @Override
    public void close() {
        this.pop();
    }

    private static /* synthetic */ String jvmdowngrader$concat$mallocAligned$1(int n) {
        return "Tried to allocate with alignment " + n + ", which is greater than the maximum 4096";
    }

    @RecordComponents(value={@RecordComponents.Value(name="addr", type=long.class)})
    @NestHost(value=MemoryStack.class)
    private static final class AddrCleaner
    extends J_L_Record
    implements Runnable {
        private final long addr;

        AddrCleaner(long addr) {
            this.addr = addr;
        }

        @Override
        public void run() {
            MemoryUtil.nmemAlignedFree(this.addr);
        }

        public final String toString() {
            return AddrCleaner.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return AddrCleaner.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return AddrCleaner.jvmdowngrader$equals$equals(this, o);
        }

        public long addr() {
            return this.addr;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(AddrCleaner addrCleaner) {
            AddrCleaner addrCleaner2 = addrCleaner;
            return "MemoryStack$AddrCleaner[" + "addr=" + addrCleaner.addr + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(AddrCleaner addrCleaner) {
            Object[] objectArray = new Object[]{addrCleaner.addr};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(AddrCleaner addrCleaner, Object object) {
            if (addrCleaner == object) {
                return true;
            }
            if (object != null && object instanceof AddrCleaner) {
                AddrCleaner addrCleaner2 = (AddrCleaner)object;
                if (addrCleaner.addr == addrCleaner2.addr) {
                    return true;
                }
            }
            return false;
        }
    }
}

