/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.vertex.format.impl;

import java.util.Map;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeFormat;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryUtil;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;

public class CompactChunkVertex
implements ChunkVertexType {
    public static final GlVertexFormat VERTEX_FORMAT = GlVertexFormat.builder(20).addElement("a_PosId", 0, GlVertexAttributeFormat.UNSIGNED_SHORT, 4, false, true).addElement("a_Color", 8, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true, false).addElement("a_TexCoord", 12, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, false).addElement("a_LightCoord", 16, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, true).build();
    public static final int STRIDE = 20;
    private static final int POSITION_MAX_VALUE = 65536;
    private static final int TEXTURE_MAX_VALUE = 32768;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;
    private static final float MODEL_SCALE = 4.8828125E-4f;
    private static final float MODEL_SCALE_INV = 2048.0f;
    private static final float TEXTURE_SCALE = 3.0517578E-5f;

    @Override
    public float getTextureScale() {
        return 3.0517578E-5f;
    }

    @Override
    public float getPositionScale() {
        return 4.8828125E-4f;
    }

    @Override
    public float getPositionOffset() {
        return -8.0f;
    }

    @Override
    public GlVertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder createEncoder() {
        return (ptr, material, vertex, sectionIndex) -> {
            MemoryUtil.memPutShort(ptr + 0L, CompactChunkVertex.encodePosition(vertex.x));
            MemoryUtil.memPutShort(ptr + 2L, CompactChunkVertex.encodePosition(vertex.y));
            MemoryUtil.memPutShort(ptr + 4L, CompactChunkVertex.encodePosition(vertex.z));
            MemoryUtil.memPutByte(ptr + 6L, (byte)(material.bits() & 0xFF));
            MemoryUtil.memPutByte(ptr + 7L, (byte)(sectionIndex & 0xFF));
            MemoryUtil.memPutInt(ptr + 8L, vertex.color);
            MemoryUtil.memPutShort(ptr + 12L, CompactChunkVertex.encodeTexture(vertex.u));
            MemoryUtil.memPutShort(ptr + 14L, CompactChunkVertex.encodeTexture(vertex.v));
            MemoryUtil.memPutInt(ptr + 16L, vertex.light);
            return ptr + 20L;
        };
    }

    @Override
    public Map<String, String> getDefines() {
        Map<String, String> map = ChunkVertexType.super.getDefines();
        map.put("USE_VERTEX_COMPRESSION", "");
        return map;
    }

    private static short encodePosition(float value) {
        return (short)((8.0f + value) * 2048.0f);
    }

    public static float decodePosition(short value) {
        return (float)Short.toUnsignedInt(value) / 2048.0f - 8.0f;
    }

    private static short encodeTexture(float value) {
        return (short)(Math.round(value * 32768.0f) & 0xFFFF);
    }
}

