/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.vertex.format.impl;

import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeFormat;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.lwjgl2.MemoryUtil;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;

public class VanillaLikeChunkVertex
implements ChunkVertexType {
    public static final int STRIDE = 28;
    public static final GlVertexFormat VERTEX_FORMAT = GlVertexFormat.builder(28).addElement("a_PosId", 0, GlVertexAttributeFormat.FLOAT, 3, false, false).addElement("a_Color", 12, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true, false).addElement("a_TexCoord", 16, GlVertexAttributeFormat.FLOAT, 2, false, false).addElement("a_LightCoord", 24, GlVertexAttributeFormat.UNSIGNED_INT, 1, false, true).build();

    @Override
    public float getPositionScale() {
        return 1.0f;
    }

    @Override
    public float getPositionOffset() {
        return 0.0f;
    }

    @Override
    public float getTextureScale() {
        return 1.0f;
    }

    @Override
    public GlVertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder createEncoder() {
        return (ptr, material, vertex, sectionIndex) -> {
            MemoryUtil.memPutFloat(ptr + 0L, vertex.x);
            MemoryUtil.memPutFloat(ptr + 4L, vertex.y);
            MemoryUtil.memPutFloat(ptr + 8L, vertex.z);
            MemoryUtil.memPutInt(ptr + 12L, vertex.color);
            MemoryUtil.memPutFloat(ptr + 16L, VanillaLikeChunkVertex.encodeTexture(vertex.u));
            MemoryUtil.memPutFloat(ptr + 20L, VanillaLikeChunkVertex.encodeTexture(vertex.v));
            MemoryUtil.memPutInt(ptr + 24L, VanillaLikeChunkVertex.encodeDrawParameters(material, sectionIndex) << 0 | VanillaLikeChunkVertex.encodeLight(vertex.light) << 16);
            return ptr + 28L;
        };
    }

    private static int encodeDrawParameters(Material material, int sectionIndex) {
        return (sectionIndex & 0xFF) << 8 | (material.bits() & 0xFF) << 0;
    }

    private static int encodeLight(int light) {
        int block = light & 0xFF;
        int sky = light >> 16 & 0xFF;
        return block << 0 | sky << 8;
    }

    private static float encodeTexture(float value) {
        return Math.min(0.99999994f, value);
    }
}

