/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.profiling;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.io.Closeable;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;

public class TimerQueryManager
implements Closeable {
    private static final int INVALID_ID = -1;
    private static final int QUERY_FRAME_LAG_COUNT = 3;
    private final ObjectArrayFIFOQueue<InFlightQuery> inFlightQueries = new ObjectArrayFIFOQueue();
    private int startQueryId = -1;
    private static final IntArrayFIFOQueue QUERY_POOL = new IntArrayFIFOQueue();
    private long lastTime;

    private static int allocateQuery() {
        if (!QUERY_POOL.isEmpty()) {
            return QUERY_POOL.dequeueInt();
        }
        return GL32C.glGenQueries();
    }

    private static void releaseQuery(int id) {
        QUERY_POOL.enqueue(id);
    }

    public void startProfiling() {
        if (this.startQueryId != -1) {
            throw new IllegalStateException("Query already started but not ended");
        }
        int id = TimerQueryManager.allocateQuery();
        GL33C.glQueryCounter((int)id, (int)36392);
        this.startQueryId = id;
    }

    public void finishProfiling() {
        if (this.startQueryId == -1) {
            throw new IllegalStateException("Trying to end query that hasn't started yet");
        }
        int id = TimerQueryManager.allocateQuery();
        GL33C.glQueryCounter((int)id, (int)36392);
        this.inFlightQueries.enqueue((Object)new InFlightQuery(this.startQueryId, id));
        this.startQueryId = -1;
    }

    public void updateTime() {
        if (this.inFlightQueries.size() < 3) {
            return;
        }
        InFlightQuery query = (InFlightQuery)this.inFlightQueries.dequeue();
        this.lastTime = query.getTimeDelta();
        query.delete();
    }

    @Override
    public void close() {
        while (!this.inFlightQueries.isEmpty()) {
            ((InFlightQuery)this.inFlightQueries.dequeue()).delete();
        }
        if (this.startQueryId != -1) {
            TimerQueryManager.releaseQuery(this.startQueryId);
            this.startQueryId = -1;
        }
    }

    public long getLastTime() {
        return this.lastTime;
    }

    private record InFlightQuery(int startTime, int endTime) {
        long getTimeDelta() {
            long startTime = GL33C.glGetQueryObjectui64((int)this.startTime, (int)34918);
            long endTime = GL33C.glGetQueryObjectui64((int)this.endTime, (int)34918);
            return endTime - startTime;
        }

        void delete() {
            TimerQueryManager.releaseQuery(this.startTime);
            TimerQueryManager.releaseQuery(this.endTime);
        }
    }
}

